/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.MessageDigest;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.X509Name;

public class X509_NAME {
    public X509Name name;

    public X509_NAME(X500Principal nm) {
        try {
            this.name = new X509Name((ASN1Sequence)new ASN1InputStream(nm.getEncoded()).readObject());
        }
        catch (Exception e) {
            this.name = null;
        }
    }

    public X509_NAME(X509Name nm) {
        this.name = nm;
    }

    public long hash() {
        try {
            byte[] bytes = this.name.getEncoded();
            byte[] md = null;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md = md5.digest(bytes);
            return (long)md[0] | (long)md[1] << 8 | (long)md[2] << 16 | (long)md[3] << 24;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean isEqual(X500Principal oname) {
        try {
            return new X500Principal(this.name.getEncoded()).equals(oname);
        }
        catch (Exception e) {
            return false;
        }
    }
}

