/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERBitString;
import org.jruby.ext.openssl.x509store.Err;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class X509_PURPOSE {
    public int purpose;
    public int trust;
    public int flags;
    public Function3 check_purpose;
    public String name;
    public String sname;
    public Object usr_data;
    private static final List xptable = new ArrayList();
    public static final Function3 cp_ssl_client = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) throws Exception {
            boolean v2;
            X509_PURPOSE xp = (X509_PURPOSE)_xp;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int ca = (Integer)_ca;
            if (x.getExtendedKeyUsage() != null && !x.getExtendedKeyUsage().contains("1.3.6.1.5.5.7.3.2")) {
                return 0;
            }
            if (ca != 0) {
                return X509_PURPOSE.check_ssl_ca(x);
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[0]) {
                return 0;
            }
            byte[] ns1 = x.getExtensionValue("2.16.840.1.113730.1.1");
            boolean bl = v2 = ns1 != null && (((DERBitString)new ASN1InputStream(ns1).readObject()).intValue() & 0x80) != 0;
            if (v2) {
                return 0;
            }
            return 1;
        }
    };
    public static final Function3 cp_ssl_server = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) throws Exception {
            boolean v2;
            X509_PURPOSE xp = (X509_PURPOSE)_xp;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int ca = (Integer)_ca;
            if (!(x.getExtendedKeyUsage() == null || x.getExtendedKeyUsage().contains("1.3.6.1.5.5.7.3.1") || x.getExtendedKeyUsage().contains("2.16.840.1.113730.4.1") || x.getExtendedKeyUsage().contains("1.3.6.1.4.1.311.10.3.3"))) {
                return 0;
            }
            if (ca != 0) {
                return X509_PURPOSE.check_ssl_ca(x);
            }
            byte[] ns1 = x.getExtensionValue("2.16.840.1.113730.1.1");
            boolean bl = v2 = ns1 != null && (((DERBitString)new ASN1InputStream(ns1).readObject()).intValue() & 0x40) != 0;
            if (v2) {
                return 0;
            }
            if (!(x.getKeyUsage() == null || x.getKeyUsage()[0] && x.getKeyUsage()[2])) {
                return 0;
            }
            return 1;
        }
    };
    public static final Function3 cp_ns_ssl_server = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) throws Exception {
            X509_PURPOSE xp = (X509_PURPOSE)_xp;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int ca = (Integer)_ca;
            int ret = cp_ssl_server.call(xp, x, _ca);
            if (ret == 0 || ca != 0) {
                return ret;
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[2]) {
                return 0;
            }
            return 1;
        }
    };
    public static final Function3 cp_smime_sign = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) throws Exception {
            X509_PURPOSE xp = (X509_PURPOSE)_xp;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int ca = (Integer)_ca;
            int ret = X509_PURPOSE.purpose_smime(x, ca);
            if (ret == 0 || ca != 0) {
                return ret;
            }
            if (!(x.getKeyUsage() == null || x.getKeyUsage()[0] && x.getKeyUsage()[1])) {
                return 0;
            }
            return ret;
        }
    };
    public static final Function3 cp_smime_encrypt = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) throws Exception {
            X509_PURPOSE xp = (X509_PURPOSE)_xp;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int ca = (Integer)_ca;
            int ret = X509_PURPOSE.purpose_smime(x, ca);
            if (ret == 0 || ca != 0) {
                return ret;
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[2]) {
                return 0;
            }
            return ret;
        }
    };
    public static final Function3 cp_crl_sign = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) throws Exception {
            X509_PURPOSE xp = (X509_PURPOSE)_xp;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int ca = (Integer)_ca;
            if (ca != 0) {
                int ca_ret = X509_PURPOSE.check_ca(x);
                if (ca_ret != 2) {
                    return ca_ret;
                }
                return 0;
            }
            if (x.getKeyUsage() != null && !x.getKeyUsage()[6]) {
                return 0;
            }
            return 1;
        }
    };
    public static final Function3 cp_no_check = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) {
            return 1;
        }
    };
    public static final Function3 cp_ocsp_helper = new Function3(){

        public int call(Object _xp, Object _x, Object _ca) throws Exception {
            if ((Integer)_ca != 0) {
                return X509_PURPOSE.check_ca((X509AuxCertificate)_x);
            }
            return 1;
        }
    };
    public static final X509_PURPOSE[] xstandard = new X509_PURPOSE[]{new X509_PURPOSE(1, 2, 0, cp_ssl_client, "SSL client", "sslclient", null), new X509_PURPOSE(2, 3, 0, cp_ssl_server, "SSL server", "sslserver", null), new X509_PURPOSE(3, 3, 0, cp_ns_ssl_server, "Netscape SSL server", "nssslserver", null), new X509_PURPOSE(4, 4, 0, cp_smime_sign, "S/MIME signing", "smimesign", null), new X509_PURPOSE(5, 4, 0, cp_smime_encrypt, "S/MIME encryption", "smimeencrypt", null), new X509_PURPOSE(6, 1, 0, cp_crl_sign, "CRL signing", "crlsign", null), new X509_PURPOSE(7, -1, 0, cp_no_check, "Any Purpose", "any", null), new X509_PURPOSE(8, 1, 0, cp_ocsp_helper, "OCSP helper", "ocsphelper", null)};

    public X509_PURPOSE() {
    }

    public X509_PURPOSE(int p, int t, int f, Function3 cp, String n, String s, Object u) {
        this.purpose = p;
        this.trust = t;
        this.flags = f;
        this.check_purpose = cp;
        this.name = n;
        this.sname = s;
        this.usr_data = u;
    }

    public static int check_purpose(X509AuxCertificate x, int id, int ca) throws Exception {
        if (id == -1) {
            return 1;
        }
        int idx = X509_PURPOSE.get_by_id(id);
        if (idx == -1) {
            return -1;
        }
        X509_PURPOSE pt = X509_PURPOSE.get0(idx);
        return pt.check_purpose.call(pt, x, new Integer(ca));
    }

    public static int set(int[] p, int purpose) {
        if (X509_PURPOSE.get_by_id(purpose) == -1) {
            Err.PUT_err(146);
            return 0;
        }
        p[0] = purpose;
        return 1;
    }

    public static int get_count() {
        return xptable.size() + xstandard.length;
    }

    public static X509_PURPOSE get0(int idx) {
        if (idx < 0) {
            return null;
        }
        if (idx < xstandard.length) {
            return xstandard[idx];
        }
        return (X509_PURPOSE)xptable.get(idx - xstandard.length);
    }

    public static int get_by_sname(String sname) {
        for (int i = 0; i < X509_PURPOSE.get_count(); ++i) {
            X509_PURPOSE xptmp = X509_PURPOSE.get0(i);
            if (!xptmp.sname.equals(sname)) continue;
            return i;
        }
        return -1;
    }

    public static int get_by_id(int purpose) {
        if (purpose >= 1 && purpose <= 8) {
            return purpose - 1;
        }
        int i = 0;
        Iterator iter = xptable.iterator();
        while (iter.hasNext()) {
            if (((X509_PURPOSE)iter.next()).purpose == purpose) {
                return i + xstandard.length;
            }
            ++i;
        }
        return -1;
    }

    public static int add(int id, int trust, int flags, Function3 ck, String name, String sname, Object arg) {
        X509_PURPOSE ptmp;
        flags &= 0xFFFFFFFE;
        flags |= 2;
        int idx = X509_PURPOSE.get_by_id(id);
        if (idx == -1) {
            ptmp = new X509_PURPOSE();
            ptmp.flags = 1;
        } else {
            ptmp = X509_PURPOSE.get0(idx);
        }
        ptmp.name = name;
        ptmp.sname = sname;
        ptmp.flags &= 1;
        ptmp.flags |= flags;
        ptmp.purpose = id;
        ptmp.trust = trust;
        ptmp.check_purpose = ck;
        ptmp.usr_data = arg;
        if (idx == -1) {
            xptable.add(ptmp);
        }
        return 1;
    }

    public static void cleanup() {
        xptable.clear();
    }

    public int get_id() {
        return this.purpose;
    }

    public String get0_name() {
        return this.name;
    }

    public String get0_sname() {
        return this.sname;
    }

    public int get_trust() {
        return this.trust;
    }

    public static int check_ca(X509AuxCertificate x) throws Exception {
        if (x.getKeyUsage() != null && !x.getKeyUsage()[5]) {
            return 0;
        }
        if (x.getExtensionValue("2.5.29.19") != null) {
            if (x.getBasicConstraints() != -1) {
                return 1;
            }
            return 0;
        }
        if (x.getVersion() == 1 && x.getIssuerX500Principal().equals(x.getSubjectX500Principal())) {
            return 3;
        }
        if (x.getKeyUsage() != null) {
            return 4;
        }
        byte[] ns1 = x.getExtensionValue("2.16.840.1.113730.1.1");
        if (ns1 != null && (((DERBitString)new ASN1InputStream(ns1).readObject()).intValue() & 7) != 0) {
            return 5;
        }
        return 0;
    }

    public static int check_ssl_ca(X509AuxCertificate x) throws Exception {
        boolean v2;
        int ca_ret = X509_PURPOSE.check_ca(x);
        if (ca_ret == 0) {
            return 0;
        }
        byte[] ns1 = x.getExtensionValue("2.16.840.1.113730.1.1");
        boolean bl = v2 = ns1 != null && (((DERBitString)new ASN1InputStream(ns1).readObject()).intValue() & 4) != 0;
        if (ca_ret != 5 || v2) {
            return ca_ret;
        }
        return 0;
    }

    public static int purpose_smime(X509AuxCertificate x, int ca) throws Exception {
        if (x.getExtendedKeyUsage() != null && !x.getExtendedKeyUsage().contains("1.3.6.1.5.5.7.3.4")) {
            return 0;
        }
        if (ca != 0) {
            boolean v2;
            int ca_ret = X509_PURPOSE.check_ca(x);
            if (ca_ret == 0) {
                return 0;
            }
            byte[] ns1 = x.getExtensionValue("2.16.840.1.113730.1.1");
            boolean bl = v2 = ns1 != null && (((DERBitString)new ASN1InputStream(ns1).readObject()).intValue() & 2) != 0;
            if (ca_ret != 5 || v2) {
                return ca_ret;
            }
            return 0;
        }
        byte[] ns1 = x.getExtensionValue("2.16.840.1.113730.1.1");
        if (ns1 != null) {
            int nscert = ((DERBitString)new ASN1InputStream(ns1).readObject()).intValue();
            if ((nscert & 0x20) != 0) {
                return 1;
            }
            if ((nscert & 0x80) != 0) {
                return 2;
            }
            return 0;
        }
        return 1;
    }
}

