/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.jruby.ext.openssl.x509store.Err;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function2;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.X509;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_LOOKUP;
import org.jruby.ext.openssl.x509store.X509_NAME;
import org.jruby.ext.openssl.x509store.X509_OBJECT;
import org.jruby.ext.openssl.x509store.X509_OBJECT_CERT;
import org.jruby.ext.openssl.x509store.X509_OBJECT_CRL;
import org.jruby.ext.openssl.x509store.X509_POLICY_TREE;
import org.jruby.ext.openssl.x509store.X509_PURPOSE;
import org.jruby.ext.openssl.x509store.X509_STORE;
import org.jruby.ext.openssl.x509store.X509_TRUST;
import org.jruby.ext.openssl.x509store.X509_VERIFY_PARAM;

public class X509_STORE_CTX {
    public X509_STORE ctx;
    public int current_method;
    public X509AuxCertificate cert;
    public List untrusted;
    public List crls;
    public X509_VERIFY_PARAM param;
    public List other_ctx;
    public Function1 verify;
    public Function2 verify_cb;
    public Function3 get_issuer;
    public Function3 check_issued;
    public Function1 check_revocation;
    public Function3 get_crl;
    public Function2 check_crl;
    public Function3 cert_crl;
    public Function1 check_policy;
    public Function1 cleanup;
    public boolean valid;
    public int last_untrusted;
    public List chain;
    public X509_POLICY_TREE tree;
    public int explicit_policy;
    public int error_depth;
    public int error;
    public X509AuxCertificate current_cert;
    public X509AuxCertificate current_issuer;
    public CRL current_crl;
    public List ex_data;
    private static final Set SUPPORT_CRIT_EXT = new HashSet();
    public static final Function3 get_issuer_sk;
    public static final Function3 default_check_issued;
    public static final Function2 null_callback;
    public static final Function1 internal_verify;
    public static final Function1 default_check_revocation;
    public static final Function3 default_get_crl;
    public static final Function2 default_check_crl;
    public static final Function3 default_cert_crl;
    public static final Function1 default_check_policy;

    public void set_depth(int depth) {
        this.param.set_depth(depth);
    }

    public void set_app_data(Object data) {
        this.set_ex_data(0, data);
    }

    public Object get_app_data() {
        return this.get_ex_data(0);
    }

    public int get1_issuer(X509AuxCertificate[] issuer, X509AuxCertificate x) throws Exception {
        X509_OBJECT[] s_obj;
        X509_NAME xn = new X509_NAME(x.getIssuerX500Principal());
        int ok = this.get_by_subject(1, xn, s_obj = new X509_OBJECT[1]);
        if (ok != 1) {
            if (ok == -1) {
                Err.PUT_err(106);
                return -1;
            }
            if (ok != 0) {
                return -1;
            }
            return 0;
        }
        X509_OBJECT obj = s_obj[0];
        if (this.check_issued.call(this, x, ((X509_OBJECT_CERT)obj).x509) != 0) {
            issuer[0] = ((X509_OBJECT_CERT)obj).x509;
            return 1;
        }
        int idx = X509_OBJECT.idx_by_subject(this.ctx.objs, 1, xn);
        if (idx == -1) {
            return 0;
        }
        for (int i = idx; i < this.ctx.objs.size(); ++i) {
            X509_OBJECT pobj = (X509_OBJECT)this.ctx.objs.get(i);
            if (pobj.type() != 1) {
                return 0;
            }
            if (!xn.isEqual(((X509_OBJECT_CERT)pobj).x509.getSubjectX500Principal())) {
                return 0;
            }
            if (this.check_issued.call(this, x, ((X509_OBJECT_CERT)pobj).x509) == 0) continue;
            issuer[0] = ((X509_OBJECT_CERT)pobj).x509;
            return 1;
        }
        return 0;
    }

    public static List transform(Collection inp) {
        ArrayList<X509AuxCertificate> o = new ArrayList<X509AuxCertificate>();
        Iterator iter = inp.iterator();
        while (iter.hasNext()) {
            o.add(X509_STORE_CTX.transform((X509Certificate)iter.next()));
        }
        return o;
    }

    public static List transform(X509Certificate[] inp) {
        ArrayList<X509AuxCertificate> o = new ArrayList<X509AuxCertificate>();
        for (int i = 0; i < inp.length; ++i) {
            o.add(X509_STORE_CTX.transform(inp[i]));
        }
        return o;
    }

    public static X509AuxCertificate transform(X509Certificate i) {
        if (i instanceof X509AuxCertificate) {
            return (X509AuxCertificate)i;
        }
        return new X509AuxCertificate(i);
    }

    public int init(X509_STORE store, X509AuxCertificate x509, List chain) {
        int ret = 1;
        this.ctx = store;
        this.current_method = 0;
        this.cert = x509;
        this.untrusted = X509_STORE_CTX.transform(chain);
        this.crls = new ArrayList();
        this.last_untrusted = 0;
        this.other_ctx = new ArrayList();
        this.valid = false;
        chain = new ArrayList();
        this.error = 0;
        this.explicit_policy = 0;
        this.error_depth = 0;
        this.current_cert = null;
        this.current_issuer = null;
        this.tree = null;
        this.param = new X509_VERIFY_PARAM();
        if (store != null) {
            ret = this.param.inherit(store.param);
        } else {
            this.param.flags |= 0x11L;
        }
        if (store != null) {
            this.verify_cb = store.verify_cb;
            this.cleanup = store.cleanup;
        } else {
            this.cleanup = Function1.iZ;
        }
        if (ret != 0) {
            ret = this.param.inherit(X509_VERIFY_PARAM.lookup("default"));
        }
        if (ret == 0) {
            Err.PUT_err(65);
            return 0;
        }
        this.check_issued = store != null && store.check_issued != null && store.check_issued != Function3.iZ ? store.check_issued : default_check_issued;
        this.get_issuer = store != null && store.get_issuer != null && store.get_issuer != Function3.iZ ? store.get_issuer : new Function3(){

            public int call(Object arg1, Object arg2, Object arg3) throws Exception {
                return ((X509_STORE_CTX)arg2).get1_issuer((X509AuxCertificate[])arg1, (X509AuxCertificate)arg3);
            }
        };
        this.verify_cb = store != null && store.verify_cb != null && store.verify_cb != Function2.iZ ? store.verify_cb : null_callback;
        this.verify = store != null && store.verify != null && store.verify != Function1.iZ ? store.verify : internal_verify;
        this.check_revocation = store != null && store.check_revocation != null && store.check_revocation != Function1.iZ ? store.check_revocation : default_check_revocation;
        this.get_crl = store != null && store.get_crl != null && store.get_crl != Function3.iZ ? store.get_crl : default_get_crl;
        this.check_crl = store != null && store.check_crl != null && store.check_crl != Function2.iZ ? store.check_crl : default_check_crl;
        this.cert_crl = store != null && store.cert_crl != null && store.cert_crl != Function3.iZ ? store.cert_crl : default_cert_crl;
        this.check_policy = default_check_policy;
        this.ex_data = new ArrayList();
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        this.ex_data.add(null);
        return 1;
    }

    public void trusted_stack(List sk) {
        this.other_ctx = sk;
        this.get_issuer = get_issuer_sk;
    }

    public void cleanup() throws Exception {
        if (this.cleanup != null && this.cleanup != Function1.iZ) {
            this.cleanup.call(this);
        }
        this.param = null;
        this.tree = null;
        this.chain = null;
        this.ex_data = null;
    }

    public X509AuxCertificate find_issuer(List sk, X509AuxCertificate x) throws Exception {
        X509AuxCertificate issuer = null;
        Iterator iter = sk.iterator();
        while (iter.hasNext()) {
            issuer = (X509AuxCertificate)iter.next();
            if (this.check_issued.call(this, x, issuer) == 0) continue;
            return issuer;
        }
        return null;
    }

    public int set_ex_data(int idx, Object data) {
        this.ex_data.set(idx, data);
        return 1;
    }

    public Object get_ex_data(int idx) {
        return this.ex_data.get(idx);
    }

    public int get_error() {
        return this.error;
    }

    public void set_error(int s) {
        this.error = s;
    }

    public int get_error_depth() {
        return this.error_depth;
    }

    public X509AuxCertificate get_current_cert() {
        return this.current_cert;
    }

    public List get_chain() {
        return this.chain;
    }

    public List get1_chain() {
        return new ArrayList(this.chain);
    }

    public void set_cert(X509AuxCertificate x) {
        this.cert = x;
    }

    public void set_chain(List sk) {
        this.untrusted = X509_STORE_CTX.transform(sk);
    }

    public void set0_crls(List sk) {
        this.crls = sk;
    }

    public int set_purpose(int purpose) {
        return this.purpose_inherit(0, purpose, 0);
    }

    public int set_trust(int trust) {
        return this.purpose_inherit(0, 0, trust);
    }

    public int purpose_inherit(int def_purpose, int purpose, int trust) {
        int idx;
        if (purpose == 0) {
            purpose = def_purpose;
        }
        if (purpose != 0) {
            idx = X509_PURPOSE.get_by_id(purpose);
            if (idx == -1) {
                Err.PUT_err(121);
                return 0;
            }
            X509_PURPOSE ptmp = X509_PURPOSE.get0(idx);
            if (ptmp.trust == -1) {
                idx = X509_PURPOSE.get_by_id(def_purpose);
                if (idx == -1) {
                    Err.PUT_err(121);
                    return 0;
                }
                ptmp = X509_PURPOSE.get0(idx);
            }
            if (trust == 0) {
                trust = ptmp.trust;
            }
        }
        if (trust != 0 && (idx = X509_TRUST.get_by_id(trust)) == -1) {
            Err.PUT_err(120);
            return 0;
        }
        if (purpose != 0 && this.param.purpose == 0) {
            this.param.purpose = purpose;
        }
        if (trust != 0 && this.param.trust == 0) {
            this.param.trust = trust;
        }
        return 1;
    }

    public void set_flags(long flags) {
        this.param.set_flags(flags);
    }

    public void set_time(long flags, Date t) {
        this.param.set_time(t);
    }

    public void set_verify_cb(Function2 verify_cb) {
        this.verify_cb = verify_cb;
    }

    X509_POLICY_TREE get0_policy_tree() {
        return this.tree;
    }

    public int get_explicit_policy() {
        return this.explicit_policy;
    }

    public X509_VERIFY_PARAM get0_param() {
        return this.param;
    }

    public void set0_param(X509_VERIFY_PARAM param) {
        this.param = param;
    }

    public int set_default(String name) {
        X509_VERIFY_PARAM p = X509_VERIFY_PARAM.lookup(name);
        if (p == null) {
            return 0;
        }
        return this.param.inherit(p);
    }

    public int get_by_subject(int type, X509_NAME name, X509_OBJECT[] ret) throws Exception {
        X509_STORE c = this.ctx;
        X509_OBJECT tmp = X509_OBJECT.retrieve_by_subject(c.objs, type, name);
        if (tmp == null) {
            for (int i = this.current_method; i < c.get_cert_methods.size(); ++i) {
                X509_OBJECT[] stmp;
                X509_LOOKUP lu = (X509_LOOKUP)c.get_cert_methods.get(i);
                int j = lu.by_subject(type, name, stmp = new X509_OBJECT[1]);
                if (j < 0) {
                    this.current_method = i;
                    return j;
                }
                if (j <= 0) continue;
                tmp = stmp[0];
                break;
            }
            this.current_method = 0;
            if (tmp == null) {
                return 0;
            }
        }
        ret[0] = tmp;
        return 1;
    }

    public int verify_cert() throws Exception {
        X509AuxCertificate[] p_xtmp;
        X509_NAME xn;
        int num;
        X509AuxCertificate xtmp = null;
        X509AuxCertificate chain_ss = null;
        boolean bad_chain = false;
        X509_VERIFY_PARAM p = this.param;
        int ok = 0;
        ArrayList sktmp = null;
        if (this.cert == null) {
            Err.PUT_err(105);
            return -1;
        }
        Function2 cb = this.verify_cb;
        if (null == this.chain) {
            this.chain = new ArrayList();
            this.chain.add(this.cert);
            this.last_untrusted = 1;
        }
        if (this.untrusted != null) {
            sktmp = new ArrayList(this.untrusted);
        }
        X509AuxCertificate x = (X509AuxCertificate)this.chain.get(num - 1);
        int depth = this.param.depth;
        for (num = this.chain.size(); depth >= num; ++num) {
            xn = new X509_NAME(x.getIssuerX500Principal());
            if (this.check_issued.call(this, x, x) != 0 || this.untrusted == null || (xtmp = this.find_issuer(sktmp, x)) == null) break;
            this.chain.add(xtmp);
            sktmp.remove(xtmp);
            ++this.last_untrusted;
            x = xtmp;
        }
        int i = this.chain.size();
        x = (X509AuxCertificate)this.chain.get(i - 1);
        xn = new X509_NAME(x.getSubjectX500Principal());
        if (this.check_issued.call(this, x, x) != 0) {
            if (this.chain.size() == 1) {
                p_xtmp = new X509AuxCertificate[]{xtmp};
                ok = this.get_issuer.call(p_xtmp, this, x);
                xtmp = p_xtmp[0];
                if (ok <= 0 || !x.equals(xtmp)) {
                    this.error = 18;
                    this.current_cert = x;
                    this.error_depth = i - 1;
                    bad_chain = true;
                    ok = cb.call(new Integer(0), this);
                    if (ok == 0) {
                        return ok;
                    }
                } else {
                    x = xtmp;
                    this.chain.set(i - 1, x);
                    this.last_untrusted = 0;
                }
            } else {
                chain_ss = (X509AuxCertificate)this.chain.remove(this.chain.size() - 1);
                --this.last_untrusted;
                x = (X509AuxCertificate)this.chain.get(--num - 1);
            }
        }
        while (depth >= num) {
            xn = new X509_NAME(x.getIssuerX500Principal());
            if (this.check_issued.call(this, x, x) != 0) break;
            p_xtmp = new X509AuxCertificate[]{xtmp};
            ok = this.get_issuer.call(p_xtmp, this, x);
            xtmp = p_xtmp[0];
            if (ok < 0) {
                return ok;
            }
            if (ok == 0) break;
            x = xtmp;
            this.chain.add(x);
            ++num;
        }
        xn = new X509_NAME(x.getIssuerX500Principal());
        if (this.check_issued.call(this, x, x) == 0) {
            if (chain_ss == null || this.check_issued.call(this, x, chain_ss) == 0) {
                this.error = this.last_untrusted >= num ? 20 : 2;
                this.current_cert = x;
            } else {
                this.chain.add(chain_ss);
                this.last_untrusted = ++num;
                this.current_cert = chain_ss;
                this.error = 19;
                chain_ss = null;
            }
            this.error_depth = num - 1;
            bad_chain = true;
            ok = cb.call(new Integer(0), this);
            if (ok == 0) {
                return ok;
            }
        }
        if ((ok = this.check_chain_extensions()) == 0) {
            return ok;
        }
        if (this.param.trust > 0) {
            ok = this.check_trust();
        }
        if (ok == 0) {
            return ok;
        }
        ok = this.check_revocation.call(this);
        if (ok == 0) {
            return ok;
        }
        ok = this.verify != null && this.verify != Function1.iZ ? this.verify.call(this) : internal_verify.call(this);
        if (ok == 0) {
            return ok;
        }
        if (!bad_chain && (this.param.flags & 0x80L) != 0L) {
            ok = this.check_policy.call(this);
        }
        return ok;
    }

    private static boolean supported_extension(String oid) {
        return SUPPORT_CRIT_EXT.contains(oid);
    }

    private static boolean unhandledCritical(X509Extension xx) {
        if (xx.getCriticalExtensionOIDs() == null || xx.getCriticalExtensionOIDs().size() == 0) {
            return false;
        }
        Iterator<String> iter = xx.getCriticalExtensionOIDs().iterator();
        while (iter.hasNext()) {
            String ss = iter.next();
            if (X509_STORE_CTX.supported_extension(ss)) continue;
            return true;
        }
        return false;
    }

    public int check_chain_extensions() throws Exception {
        int ok = 0;
        int proxy_path_length = 0;
        boolean allow_proxy_certs = (this.param.flags & 0x40L) != 0L;
        Function2 cb = this.verify_cb;
        int must_be_ca = -1;
        if (System.getenv("OPENSSL_ALLOW_PROXY_CERTS") != null && !"false".equalsIgnoreCase(System.getenv("OPENSSL_ALLOW_PROXY_CERTS"))) {
            allow_proxy_certs = true;
        }
        for (int i = 0; i < this.last_untrusted; ++i) {
            X509AuxCertificate x = (X509AuxCertificate)this.chain.get(i);
            if ((this.param.flags & 0x10L) == 0L && X509_STORE_CTX.unhandledCritical(x)) {
                this.error = 34;
                this.error_depth = i;
                this.current_cert = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (!allow_proxy_certs && x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                this.error = 40;
                this.error_depth = i;
                this.current_cert = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            int ret = X509_PURPOSE.check_ca(x);
            switch (must_be_ca) {
                case -1: {
                    if ((this.param.flags & 0x20L) != 0L && ret != 1 && ret != 0) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                    break;
                }
                case 0: {
                    if (ret != 0) {
                        ret = 0;
                        this.error = 37;
                        break;
                    }
                    ret = 1;
                    break;
                }
                default: {
                    if (ret == 0 || (this.param.flags & 0x20L) != 0L && ret != 1) {
                        ret = 0;
                        this.error = 24;
                        break;
                    }
                    ret = 1;
                }
            }
            if (ret == 0) {
                this.error_depth = i;
                this.current_cert = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (this.param.purpose > 0 && ((ret = X509_PURPOSE.check_purpose(x, this.param.purpose, must_be_ca > 0 ? 1 : 0)) == 0 || (this.param.flags & 0x20L) != 0L && ret != 1)) {
                this.error = 26;
                this.error_depth = i;
                this.current_cert = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (i > 1 && x.getBasicConstraints() != -1 && i > x.getBasicConstraints() + proxy_path_length + 1) {
                this.error = 25;
                this.error_depth = i;
                this.current_cert = x;
                ok = cb.call(new Integer(0), this);
                if (ok == 0) {
                    return ok;
                }
            }
            if (x.getExtensionValue("1.3.6.1.5.5.7.1.14") != null) {
                int pcpathlen;
                DERSequence pci = (DERSequence)new ASN1InputStream(x.getExtensionValue("1.3.6.1.5.5.7.1.14")).readObject();
                if (pci.size() > 0 && pci.getObjectAt(0) instanceof DERInteger && i > (pcpathlen = ((DERInteger)pci.getObjectAt(0)).getValue().intValue())) {
                    this.error = 38;
                    this.error_depth = i;
                    this.current_cert = x;
                    ok = cb.call(new Integer(0), this);
                    if (ok == 0) {
                        return ok;
                    }
                }
                ++proxy_path_length;
                must_be_ca = 0;
                continue;
            }
            must_be_ca = 1;
        }
        return 1;
    }

    public int check_trust() throws Exception {
        Function2 cb = this.verify_cb;
        int i = this.chain.size() - 1;
        X509AuxCertificate x = (X509AuxCertificate)this.chain.get(i);
        int ok = X509_TRUST.check_trust(x, this.param.trust, 0);
        if (ok == 1) {
            return 1;
        }
        this.error_depth = 1;
        this.current_cert = x;
        this.error = ok == 2 ? 28 : 27;
        return cb.call(new Integer(0), this);
    }

    public int check_cert_time(X509AuxCertificate x) throws Exception {
        Date ptime = null;
        ptime = (this.param.flags & 2L) != 0L ? this.param.check_time : Calendar.getInstance().getTime();
        if (!x.getNotBefore().before(ptime)) {
            this.error = 9;
            this.current_cert = x;
            if (this.verify_cb.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        if (!x.getNotAfter().after(ptime)) {
            this.error = 10;
            this.current_cert = x;
            if (this.verify_cb.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        return 1;
    }

    public int check_cert() throws Exception {
        X509AuxCertificate x;
        X509CRL[] crl = new X509CRL[1];
        int cnum = this.error_depth;
        this.current_cert = x = (X509AuxCertificate)this.chain.get(cnum);
        int ok = this.get_crl.call(this, crl, x);
        if (ok == 0) {
            this.error = 3;
            ok = this.verify_cb.call(new Integer(0), this);
            this.current_crl = null;
            return ok;
        }
        this.current_crl = crl[0];
        ok = this.check_crl.call(this, crl[0]);
        if (ok == 0) {
            this.current_crl = null;
            return ok;
        }
        ok = this.cert_crl.call(this, crl[0], x);
        this.current_crl = null;
        return ok;
    }

    public int check_crl_time(X509CRL crl, int notify) throws Exception {
        this.current_crl = crl;
        Date ptime = null;
        ptime = (this.param.flags & 2L) != 0L ? this.param.check_time : Calendar.getInstance().getTime();
        if (!crl.getThisUpdate().before(ptime)) {
            this.error = 11;
            if (notify == 0 || this.verify_cb.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        if (crl.getNextUpdate() != null && !crl.getNextUpdate().after(ptime)) {
            this.error = 12;
            if (notify == 0 || this.verify_cb.call(new Integer(0), this) == 0) {
                return 0;
            }
        }
        this.current_crl = null;
        return 1;
    }

    public int get_crl_sk(X509CRL[] pcrl, X509_NAME nm, List crls) throws Exception {
        X509CRL best_crl = null;
        for (int i = 0; i < crls.size(); ++i) {
            X509CRL crl = (X509CRL)crls.get(i);
            if (!nm.isEqual(crl.getIssuerX500Principal())) continue;
            if (this.check_crl_time(crl, 0) != 0) {
                pcrl[0] = crl;
                return 1;
            }
            best_crl = crl;
        }
        if (best_crl != null) {
            pcrl[0] = best_crl;
        }
        return 0;
    }

    static {
        SUPPORT_CRIT_EXT.add("2.16.840.1.113730.1.1");
        SUPPORT_CRIT_EXT.add("2.5.29.15");
        SUPPORT_CRIT_EXT.add("2.5.29.17");
        SUPPORT_CRIT_EXT.add("2.5.29.19");
        SUPPORT_CRIT_EXT.add("2.5.29.37");
        SUPPORT_CRIT_EXT.add("1.3.6.1.5.5.7.1.14");
        get_issuer_sk = new Function3(){

            public int call(Object a1, Object a2, Object a3) throws Exception {
                X509AuxCertificate[] issuer = (X509AuxCertificate[])a1;
                X509_STORE_CTX ctx = (X509_STORE_CTX)a2;
                X509AuxCertificate x = (X509AuxCertificate)a3;
                issuer[0] = ctx.find_issuer(ctx.other_ctx, x);
                if (issuer[0] != null) {
                    return 1;
                }
                return 0;
            }
        };
        default_check_issued = new Function3(){

            public int call(Object a1, Object a2, Object a3) throws Exception {
                X509_STORE_CTX ctx = (X509_STORE_CTX)a1;
                X509AuxCertificate issuer = (X509AuxCertificate)a3;
                X509AuxCertificate x = (X509AuxCertificate)a2;
                int ret = X509.check_issued(issuer, x);
                if (ret == 0) {
                    return 1;
                }
                if ((ctx.param.flags & 1L) == 0L) {
                    return 0;
                }
                ctx.error = ret;
                ctx.current_cert = x;
                ctx.current_issuer = issuer;
                return ctx.verify_cb.call(new Integer(0), ctx);
            }
        };
        null_callback = new Function2(){

            public int call(Object a1, Object a2) {
                return (Integer)a1;
            }
        };
        internal_verify = new Function1(){

            public int call(Object a1) throws Exception {
                X509_STORE_CTX ctx = (X509_STORE_CTX)a1;
                Function2 cb = ctx.verify_cb;
                int n = ctx.chain.size();
                ctx.error_depth = n - 1;
                X509AuxCertificate xi = (X509AuxCertificate)ctx.chain.get(--n);
                X509AuxCertificate xs = null;
                int ok = 0;
                if (ctx.check_issued.call(ctx, xi, xi) != 0) {
                    xs = xi;
                } else {
                    if (n <= 0) {
                        ctx.error = 21;
                        ctx.current_cert = xi;
                        ok = cb.call(new Integer(0), ctx);
                        return ok;
                    }
                    ctx.error_depth = --n;
                    xs = (X509AuxCertificate)ctx.chain.get(n);
                }
                while (n >= 0) {
                    block9: {
                        ctx.error_depth = n;
                        if (!xs.isValid()) {
                            try {
                                xs.verify(xi.getPublicKey());
                            }
                            catch (Exception e) {
                                System.err.println("n: " + n);
                                System.err.println("verifying: " + xs);
                                System.err.println("verifying with issuer?: " + xi);
                                System.err.println("verifying with issuer.key?: " + xi.getPublicKey());
                                System.err.println("exception: " + e);
                                ctx.error = 7;
                                ctx.current_cert = xs;
                                ok = cb.call(new Integer(0), ctx);
                                if (ok != 0) break block9;
                                return ok;
                            }
                        }
                    }
                    xs.setValid(true);
                    ok = ctx.check_cert_time(xs);
                    if (ok == 0) {
                        return ok;
                    }
                    ctx.current_issuer = xi;
                    ctx.current_cert = xs;
                    ok = cb.call(new Integer(1), ctx);
                    if (ok == 0) {
                        return ok;
                    }
                    if (--n < 0) continue;
                    xi = xs;
                    xs = (X509AuxCertificate)ctx.chain.get(n);
                }
                ok = 1;
                return ok;
            }
        };
        default_check_revocation = new Function1(){

            public int call(Object a1) throws Exception {
                X509_STORE_CTX ctx = (X509_STORE_CTX)a1;
                int ok = 0;
                if ((ctx.param.flags & 4L) == 0L) {
                    return 1;
                }
                int last = (ctx.param.flags & 8L) != 0L ? ctx.chain.size() - 1 : 0;
                int i = 0;
                while (i <= last) {
                    ctx.error_depth = i++;
                    ok = ctx.check_cert();
                    if (ok != 0) continue;
                    return 0;
                }
                return 1;
            }
        };
        default_get_crl = new Function3(){

            public int call(Object a1, Object a2, Object a3) throws Exception {
                X509_STORE_CTX ctx = (X509_STORE_CTX)a1;
                X509CRL[] pcrl = (X509CRL[])a2;
                X509CRL[] crl = new X509CRL[1];
                X509AuxCertificate x = (X509AuxCertificate)a3;
                X509_NAME nm = new X509_NAME(x.getIssuerX500Principal());
                int ok = ctx.get_crl_sk(crl, nm, ctx.crls);
                if (ok != 0) {
                    pcrl[0] = crl[0];
                    return 1;
                }
                X509_OBJECT[] xobj = new X509_OBJECT[1];
                ok = ctx.get_by_subject(2, nm, xobj);
                if (ok == 0) {
                    if (crl[0] != null) {
                        pcrl[0] = crl[0];
                        return 1;
                    }
                    return 0;
                }
                pcrl[0] = (X509CRL)((X509_OBJECT_CRL)xobj[0]).crl;
                return 1;
            }
        };
        default_check_crl = new Function2(){

            public int call(Object a1, Object a2) throws Exception {
                int ok;
                X509CRL crl;
                X509_STORE_CTX ctx;
                block13: {
                    ctx = (X509_STORE_CTX)a1;
                    crl = (X509CRL)a2;
                    X509AuxCertificate issuer = null;
                    ok = 0;
                    int cnum = ctx.error_depth;
                    int chnum = ctx.chain.size() - 1;
                    if (cnum < chnum) {
                        issuer = (X509AuxCertificate)ctx.chain.get(cnum + 1);
                    } else {
                        issuer = (X509AuxCertificate)ctx.chain.get(chnum);
                        if (ctx.check_issued.call(ctx, issuer, issuer) == 0) {
                            ctx.error = 33;
                            ok = ctx.verify_cb.call(new Integer(0), ctx);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                    }
                    if (issuer != null) {
                        PublicKey ikey;
                        if (issuer.getKeyUsage() != null && !issuer.getKeyUsage()[6]) {
                            ctx.error = 35;
                            ok = ctx.verify_cb.call(new Integer(0), ctx);
                            if (ok == 0) {
                                return ok;
                            }
                        }
                        if ((ikey = issuer.getPublicKey()) == null) {
                            ctx.error = 6;
                            ok = ctx.verify_cb.call(new Integer(0), ctx);
                            if (ok == 0) {
                                return ok;
                            }
                        } else {
                            try {
                                crl.verify(ikey);
                            }
                            catch (Exception e) {
                                ctx.error = 8;
                                ok = ctx.verify_cb.call(new Integer(0), ctx);
                                if (ok != 0) break block13;
                                return ok;
                            }
                        }
                    }
                }
                if ((ok = ctx.check_crl_time(crl, 1)) == 0) {
                    return ok;
                }
                return 1;
            }
        };
        default_cert_crl = new Function3(){

            public int call(Object a1, Object a2, Object a3) throws Exception {
                int ok;
                X509_STORE_CTX ctx = (X509_STORE_CTX)a1;
                X509CRL crl = (X509CRL)a2;
                X509AuxCertificate x = (X509AuxCertificate)a3;
                if (crl.getRevokedCertificate(x.getSerialNumber()) != null) {
                    ctx.error = 23;
                    ok = ctx.verify_cb.call(new Integer(0), ctx);
                    if (ok == 0) {
                        return 0;
                    }
                }
                if ((ctx.param.flags & 0x10L) != 0L) {
                    return 1;
                }
                if (crl.getCriticalExtensionOIDs() != null && crl.getCriticalExtensionOIDs().size() > 0) {
                    ctx.error = 36;
                    ok = ctx.verify_cb.call(new Integer(0), ctx);
                    if (ok == 0) {
                        return 0;
                    }
                }
                return 1;
            }
        };
        default_check_policy = new Function1(){

            public int call(Object a1) throws Exception {
                return 1;
            }
        };
    }
}

