/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.ext.openssl.x509store.Err;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509_AUX;
import org.jruby.ext.openssl.x509store.X509_PURPOSE;

public class X509_TRUST {
    public int trust;
    public int flags;
    public Function3 check_trust;
    public String name;
    public String arg1;
    public Object arg2;
    private static final List trtable = new ArrayList();
    public static final Function3 trust_compat = new Function3(){

        public int call(Object _trust, Object _x, Object _flags) throws Exception {
            X509_TRUST trust = (X509_TRUST)_trust;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int flags = (Integer)_flags;
            X509_PURPOSE.check_purpose(x, -1, 0);
            if (x.getIssuerX500Principal().equals(x.getSubjectX500Principal())) {
                return 1;
            }
            return 3;
        }
    };
    public static final Function3 trust_1oidany = new Function3(){

        public int call(Object _trust, Object _x, Object _flags) throws Exception {
            X509_TRUST trust = (X509_TRUST)_trust;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int flags = (Integer)_flags;
            X509_AUX ax = x.getAux();
            if (ax != null && (ax.trust.size() > 0 || ax.reject.size() > 0)) {
                return obj_trust.call(trust.arg1, x, new Integer(flags));
            }
            return trust_compat.call(trust, x, new Integer(flags));
        }
    };
    public static final Function3 trust_1oid = new Function3(){

        public int call(Object _trust, Object _x, Object _flags) throws Exception {
            X509_TRUST trust = (X509_TRUST)_trust;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int flags = (Integer)_flags;
            if (x.getAux() != null) {
                return obj_trust.call(trust.arg1, x, new Integer(flags));
            }
            return 3;
        }
    };
    public static final Function3 obj_trust;
    public static Function3 default_trust;
    public static final X509_TRUST[] trstandard;

    public X509_TRUST() {
    }

    public X509_TRUST(int t, int f, Function3 ct, String n, String a1, Object a2) {
        this.trust = t;
        this.flags = f;
        this.check_trust = ct;
        this.name = n;
        this.arg1 = a1;
        this.arg2 = a2;
    }

    public static Function3 set_default(Function3 trust) {
        Function3 old_trust = default_trust;
        default_trust = trust;
        return old_trust;
    }

    public static int check_trust(X509AuxCertificate x, int id, int flags) throws Exception {
        if (id == -1) {
            return 1;
        }
        int idx = X509_TRUST.get_by_id(id);
        if (idx == -1) {
            return default_trust.call(new Integer(id), x, new Integer(flags));
        }
        X509_TRUST pt = X509_TRUST.get0(idx);
        return pt.check_trust.call(pt, x, new Integer(flags));
    }

    public static int get_count() {
        return trtable.size() + trstandard.length;
    }

    public static X509_TRUST get0(int idx) {
        if (idx < 0) {
            return null;
        }
        if (idx < trstandard.length) {
            return trstandard[idx];
        }
        return (X509_TRUST)trtable.get(idx - trstandard.length);
    }

    public static int get_by_id(int id) {
        if (id >= 1 && id <= 7) {
            return id - 1;
        }
        int i = 0;
        Iterator iter = trtable.iterator();
        while (iter.hasNext()) {
            if (((X509_TRUST)iter.next()).trust == id) {
                return i + trstandard.length;
            }
            ++i;
        }
        return -1;
    }

    public static int set(int[] t, int trust) {
        if (X509_TRUST.get_by_id(trust) == -1) {
            Err.PUT_err(123);
            return 0;
        }
        t[0] = trust;
        return 1;
    }

    public static int add(int id, int flags, Function3 ck, String name, String arg1, Object arg2) {
        X509_TRUST trtmp;
        flags &= 0xFFFFFFFE;
        flags |= 2;
        int idx = X509_TRUST.get_by_id(id);
        if (idx == -1) {
            trtmp = new X509_TRUST();
            trtmp.flags = 1;
        } else {
            trtmp = X509_TRUST.get0(idx);
        }
        trtmp.name = name;
        trtmp.flags &= 1;
        trtmp.flags |= flags;
        trtmp.trust = id;
        trtmp.check_trust = ck;
        trtmp.arg1 = arg1;
        trtmp.arg2 = arg2;
        if (idx == -1) {
            trtable.add(trtmp);
        }
        return 1;
    }

    public static void cleanup() {
        trtable.clear();
    }

    public int get_flags() {
        return this.flags;
    }

    public String get0_name() {
        return this.name;
    }

    public int get_trust() {
        return this.trust;
    }

    static {
        default_trust = obj_trust = new Function3(){

            public int call(Object _id, Object _x, Object _flags) {
                String id = (String)_id;
                X509AuxCertificate x = (X509AuxCertificate)_x;
                int flags = (Integer)_flags;
                X509_AUX ax = x.getAux();
                if (null == ax) {
                    return 3;
                }
                Iterator iter = ax.reject.iterator();
                while (iter.hasNext()) {
                    if (!((String)iter.next()).equals(id)) continue;
                    return 2;
                }
                iter = ax.trust.iterator();
                while (iter.hasNext()) {
                    if (!((String)iter.next()).equals(id)) continue;
                    return 1;
                }
                return 3;
            }
        };
        trstandard = new X509_TRUST[]{new X509_TRUST(1, 0, trust_compat, "compatible", null, null), new X509_TRUST(2, 0, trust_1oidany, "SSL Client", "1.3.6.1.5.5.7.3.2", null), new X509_TRUST(3, 0, trust_1oidany, "SSL Server", "1.3.6.1.5.5.7.3.1", null), new X509_TRUST(4, 0, trust_1oidany, "S/MIME email", "1.3.6.1.5.5.7.3.4", null), new X509_TRUST(5, 0, trust_1oidany, "Object Signer", "1.3.6.1.5.5.7.3.3", null), new X509_TRUST(6, 0, trust_1oid, "OCSP responder", "1.3.6.1.5.5.7.3.9", null), new X509_TRUST(7, 0, trust_1oid, "OCSP request", "1.3.6.1.5.5.7.48.1", null)};
    }
}

