/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.IRuby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNativeThread
extends Thread {
    private IRuby runtime;
    private Frame currentFrame;
    private Block currentBlock;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;

    protected RubyNativeThread(RubyThread rubyThread, IRubyObject[] args) {
        super(rubyThread.getRuntime().getThreadService().getRubyThreadGroup(), "Ruby Thread" + rubyThread.hash());
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext tc = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc();
        this.currentFrame = tc.getCurrentFrame();
        this.currentBlock = tc.getCurrentBlock();
        this.arguments = args;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.runtime.getThreadService().registerNewThread(this.rubyThread);
        ThreadContext context = this.runtime.getCurrentContext();
        context.preRunThread(this.currentFrame, this.currentBlock);
        try {
            this.rubyThread.notifyStarted();
            this.proc.call(this.arguments);
            this.rubyThread.cleanTerminate();
        }
        catch (ThreadKill tk) {
            Object object = this.rubyThread.killLock;
            synchronized (object) {
                this.rubyThread.killLock.notifyAll();
            }
        }
        catch (RaiseException e) {
            this.rubyThread.exceptionRaised(e);
        }
        finally {
            this.runtime.getThreadService().setCritical(false);
            ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
        }
    }
}

