/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class AliasMethod
extends AbstractMethod {
    private ICallable oldMethod;
    private String oldName;

    public AliasMethod(ICallable oldMethod, String oldName) {
        super(oldMethod.getImplementationClass(), oldMethod.getVisibility());
        this.oldName = oldName;
        this.oldMethod = oldMethod;
    }

    public String getOriginalName() {
        return this.oldName;
    }

    public void preMethod(ThreadContext context, RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
        this.oldMethod.preMethod(context, this.implementationClass, recv, name, args, noSuper);
    }

    public void postMethod(ThreadContext context) {
        this.oldMethod.postMethod(context);
    }

    public IRubyObject internalCall(ThreadContext context, IRubyObject receiver, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
        return this.oldMethod.internalCall(context, receiver, lastClass, this.oldName, args, noSuper);
    }

    public ICallable dup() {
        return new AliasMethod(this.oldMethod, this.oldName);
    }

    public boolean needsImplementer() {
        return this.oldMethod.needsImplementer();
    }
}

