/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import java.util.Iterator;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public final class DefaultMethod
extends AbstractMethod {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private SinglyLinkedList cref;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, SinglyLinkedList cref) {
        super(implementationClass, visibility);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.cref = cref;
        if (!$assertionsDisabled && argsNode == null) {
            throw new AssertionError();
        }
    }

    public void preMethod(ThreadContext context, RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
        context.preDefMethodInternalCall(lastClass, recv, name, args, noSuper, this.cref, this.staticScope);
    }

    public void postMethod(ThreadContext context) {
        context.postDefMethodInternalCall();
    }

    public IRubyObject internalCall(ThreadContext context, IRubyObject receiver, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
        if (!$assertionsDisabled && args == null) {
            throw new AssertionError();
        }
        IRuby runtime = context.getRuntime();
        RubyProc blockArg = null;
        if (this.argsNode.getBlockArgNode() != null && context.isBlockGiven()) {
            blockArg = runtime.newProc();
            blockArg.getBlock().isLambda = context.getCurrentBlock().isLambda;
            context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), blockArg, 0);
        }
        try {
            this.prepareArguments(context, runtime, receiver, args);
            this.getArity().checkArity(runtime, args);
            this.traceCall(context, runtime, receiver, name);
            IRubyObject iRubyObject = EvaluationState.eval(context, this.body, receiver);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump && je.getPrimaryData() == this) {
                IRubyObject iRubyObject = (IRubyObject)je.getSecondaryData();
                return iRubyObject;
            }
            throw je;
        }
        finally {
            this.traceReturn(context, runtime, receiver, name);
        }
    }

    private void prepareArguments(ThreadContext context, IRuby runtime, IRubyObject receiver, IRubyObject[] args) {
        boolean hasOptArgs;
        int expectedArgsCount = this.argsNode.getArgsCount();
        int restArg = this.argsNode.getRestArg();
        boolean bl = hasOptArgs = this.argsNode.getOptArgs() != null;
        if (expectedArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + expectedArgsCount + ")");
        }
        if (expectedArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, expectedArgsCount);
        }
        if (hasOptArgs || restArg != -1) {
            args = this.prepareOptOrRestArgs(context, runtime, args, expectedArgsCount, restArg, hasOptArgs);
        }
        context.setFrameArgs(args);
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext context, IRuby runtime, IRubyObject[] args, int expectedArgsCount, int restArg, boolean hasOptArgs) {
        int i;
        int opt;
        if (restArg == -1 && hasOptArgs && (opt = expectedArgsCount + this.argsNode.getOptArgs().size()) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + opt + ")");
        }
        int count = expectedArgsCount;
        if (this.argsNode.getOptArgs() != null) {
            count += this.argsNode.getOptArgs().size();
        }
        ArrayList<IRubyObject> allArgs = new ArrayList<IRubyObject>();
        for (i = 0; i < count && i < args.length; ++i) {
            allArgs.add(args[i]);
        }
        if (hasOptArgs) {
            ListNode optArgs = this.argsNode.getOptArgs();
            Iterator iter = optArgs.iterator();
            for (int i2 = expectedArgsCount; i2 < args.length && iter.hasNext(); ++i2) {
                AssignmentVisitor.assign(context, context.getFrameSelf(), (Node)iter.next(), args[i2], true);
                ++expectedArgsCount;
            }
            while (iter.hasNext()) {
                allArgs.add(EvaluationState.eval(context, (Node)iter.next(), context.getFrameSelf()));
            }
        }
        if (restArg != -1) {
            for (i = expectedArgsCount; i < args.length; ++i) {
                allArgs.add(args[i]);
            }
            if (restArg >= 0) {
                RubyArray array = runtime.newArray(args.length - expectedArgsCount);
                for (int i3 = expectedArgsCount; i3 < args.length; ++i3) {
                    array.append(args[i3]);
                }
                context.getCurrentScope().setValue(restArg, array, 0);
            }
        }
        args = allArgs.toArray(new IRubyObject[allArgs.size()]);
        return args;
    }

    private void traceReturn(ThreadContext context, IRuby runtime, IRubyObject receiver, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callTraceFunction(context, "return", position, receiver, name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, IRuby runtime, IRubyObject receiver, String name) {
        if (runtime.getTraceFunction() == null) {
            return;
        }
        ISourcePosition position = this.body != null ? this.body.getPosition() : context.getPosition();
        runtime.callTraceFunction(context, "call", position, receiver, name, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public ICallable dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.cref);
    }

    static {
        $assertionsDisabled = !DefaultMethod.class.desiredAssertionStatus();
    }
}

