/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import org.jruby.IRuby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class Java {
    static /* synthetic */ Class class$java$lang$Object;

    public static RubyModule createJavaModule(IRuby runtime) {
        RubyModule javaModule = runtime.defineModule("Java");
        CallbackFactory callbackFactory = runtime.callbackFactory(Java.class);
        javaModule.defineModuleFunction("define_exception_handler", callbackFactory.getOptSingletonMethod("define_exception_handler"));
        javaModule.defineModuleFunction("primitive_to_java", callbackFactory.getSingletonMethod("primitive_to_java", IRubyObject.class));
        javaModule.defineModuleFunction("java_to_primitive", callbackFactory.getSingletonMethod("java_to_primitive", IRubyObject.class));
        javaModule.defineModuleFunction("java_to_ruby", callbackFactory.getSingletonMethod("java_to_ruby", IRubyObject.class));
        javaModule.defineModuleFunction("ruby_to_java", callbackFactory.getSingletonMethod("ruby_to_java", IRubyObject.class));
        javaModule.defineModuleFunction("new_proxy_instance", callbackFactory.getOptSingletonMethod("new_proxy_instance"));
        JavaObject.createJavaObjectClass(runtime, javaModule);
        JavaArray.createJavaArrayClass(runtime, javaModule);
        JavaClass.createJavaClassClass(runtime, javaModule);
        JavaMethod.createJavaMethodClass(runtime, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime, javaModule);
        JavaField.createJavaFieldClass(runtime, javaModule);
        return javaModule;
    }

    public static IRubyObject define_exception_handler(IRubyObject recv, IRubyObject[] args) {
        String name = args[0].toString();
        RubyProc handler = null;
        handler = args.length > 1 ? (RubyProc)args[1] : recv.getRuntime().newProc();
        recv.getRuntime().getJavaSupport().defineExceptionHandler(name, handler);
        return recv;
    }

    public static IRubyObject primitive_to_java(IRubyObject recv, IRubyObject object) {
        Object javaObject;
        if (object instanceof JavaObject) {
            return object;
        }
        IRuby runtime = recv.getRuntime();
        if (object.isNil()) {
            javaObject = null;
        } else if (object instanceof RubyFixnum) {
            javaObject = new Long(((RubyFixnum)object).getLongValue());
        } else if (object instanceof RubyBignum) {
            javaObject = ((RubyBignum)object).getValue();
        } else if (object instanceof RubyFloat) {
            javaObject = new Double(((RubyFloat)object).getValue());
        } else if (object instanceof RubyString) {
            javaObject = ((RubyString)object).toString();
        } else if (object instanceof RubyBoolean) {
            javaObject = object.isTrue();
        } else if (object instanceof RubyTime) {
            long milliseconds = ((RubyNumeric)object.callMethod(recv.getRuntime().getCurrentContext(), "to_i")).getLongValue();
            javaObject = new Date(milliseconds);
        } else {
            javaObject = object;
        }
        return JavaObject.wrap(runtime, javaObject);
    }

    public static IRubyObject java_to_ruby(IRubyObject recv, IRubyObject object) {
        if (object instanceof JavaObject) {
            object = JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        if (object instanceof JavaObject) {
            return recv.getRuntime().getModule("JavaUtilities").callMethod(recv.getRuntime().getCurrentContext(), "wrap", object);
        }
        return object;
    }

    public static IRubyObject ruby_to_java(IRubyObject recv, IRubyObject object) {
        if (object.respondsTo("to_java_object")) {
            return object.callMethod(recv.getRuntime().getCurrentContext(), "to_java_object");
        }
        return Java.primitive_to_java(recv, object);
    }

    public static IRubyObject java_to_primitive(IRubyObject recv, IRubyObject object) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    public static IRubyObject new_proxy_instance(final IRubyObject recv, IRubyObject[] args) {
        RubyProc proc;
        int size = recv.checkArgumentCount(args, 1, -1) - 1;
        if (args[size] instanceof RubyProc) {
            proc = (RubyProc)args[size];
        } else {
            proc = recv.getRuntime().newProc();
            ++size;
        }
        Class[] interfaces = new Class[size];
        for (int i = 0; i < size; ++i) {
            if (!(args[i] instanceof JavaClass) || !((JavaClass)args[i]).interface_p().isTrue()) {
                throw recv.getRuntime().newArgumentError("Java interface expected.");
            }
            interfaces[i] = ((JavaClass)args[i]).javaClass();
        }
        return JavaObject.wrap(recv.getRuntime(), Proxy.newProxyInstance(recv.getRuntime().getJavaSupport().getJavaClassLoader(), interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] nargs) throws Throwable {
                int methodArgsLength = method.getParameterTypes().length;
                String methodName = method.getName();
                if (methodName.equals("toString") && methodArgsLength == 0) {
                    return proxy.getClass().getName();
                }
                if (methodName.equals("hashCode") && methodArgsLength == 0) {
                    return new Integer(proxy.getClass().hashCode());
                }
                if (methodName.equals("equals") && methodArgsLength == 1 && method.getParameterTypes()[0].equals(class$java$lang$Object == null ? (class$java$lang$Object = Java.class$("java.lang.Object")) : class$java$lang$Object)) {
                    return proxy == nargs[0];
                }
                int length = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(recv.getRuntime(), proxy);
                rubyArgs[1] = new JavaMethod(recv.getRuntime(), method);
                for (int i = 0; i < length; ++i) {
                    rubyArgs[i + 2] = JavaObject.wrap(recv.getRuntime(), nargs[i]);
                }
                return JavaUtil.convertArgument(proc.call(rubyArgs), method.getReturnType());
            }
        }));
    }
}

