/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConstructor
extends JavaCallable {
    private Constructor constructor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static RubyClass createJavaConstructorClass(IRuby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaConstructor", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaConstructor.class);
        JavaCallable.registerRubyMethods(runtime, result, JavaConstructor.class);
        result.defineMethod("arity", callbackFactory.getMethod("arity"));
        result.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        result.defineMethod("argument_types", callbackFactory.getMethod("argument_types"));
        result.defineMethod("new_instance", callbackFactory.getOptMethod("new_instance"));
        return result;
    }

    public JavaConstructor(IRuby runtime, Constructor constructor) {
        super(runtime, runtime.getModule("Java").getClass("JavaConstructor"));
        this.constructor = constructor;
    }

    public int getArity() {
        return this.constructor.getParameterTypes().length;
    }

    public IRubyObject new_instance(IRubyObject[] args) {
        if (args.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, this.getArity());
        }
        Object[] constructorArguments = new Object[args.length];
        Class<?>[] types = this.constructor.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            constructorArguments[i] = JavaUtil.convertArgument(args[i], types[i]);
        }
        try {
            Object result = this.constructor.newInstance(constructorArguments);
            return JavaObject.wrap(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + ", got [" + constructorArguments[0].getClass().getName() + ", ...]");
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        catch (InstantiationException ie) {
            throw this.getRuntime().newTypeError("can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }

    protected String nameOnInspection() {
        return this.getType().toString();
    }

    protected Class[] parameterTypes() {
        return this.constructor.getParameterTypes();
    }

    protected int getModifiers() {
        return this.constructor.getModifiers();
    }

    protected AccessibleObject accesibleObject() {
        return this.constructor;
    }

    static {
        $assertionsDisabled = !JavaConstructor.class.desiredAssertionStatus();
    }
}

