/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaMethod
extends JavaCallable {
    private final Method method;

    public static RubyClass createJavaMethodClass(IRuby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaMethod", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaMethod.class);
        JavaAccessibleObject.registerRubyMethods(runtime, result);
        result.defineMethod("name", callbackFactory.getMethod("name"));
        result.defineMethod("arity", callbackFactory.getMethod("arity"));
        result.defineMethod("public?", callbackFactory.getMethod("public_p"));
        result.defineMethod("final?", callbackFactory.getMethod("final_p"));
        result.defineMethod("static?", callbackFactory.getMethod("static_p"));
        result.defineMethod("invoke", callbackFactory.getOptMethod("invoke"));
        result.defineMethod("invoke_static", callbackFactory.getOptMethod("invoke_static"));
        result.defineMethod("argument_types", callbackFactory.getMethod("argument_types"));
        result.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        result.defineMethod("return_type", callbackFactory.getMethod("return_type"));
        return result;
    }

    public JavaMethod(IRuby runtime, Method method) {
        super(runtime, runtime.getModule("Java").getClass("JavaMethod"));
        this.method = method;
        if (Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getClass().getModifiers()) && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            this.accesibleObject().setAccessible(true);
        }
    }

    public static JavaMethod create(IRuby runtime, Method method) {
        return new JavaMethod(runtime, method);
    }

    public static JavaMethod create(IRuby runtime, Class javaClass, String methodName, Class[] argumentTypes) {
        try {
            Method method = javaClass.getMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime, method);
        }
        catch (NoSuchMethodException e) {
            throw runtime.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public static JavaMethod createDeclared(IRuby runtime, Class javaClass, String methodName, Class[] argumentTypes) {
        try {
            Method method = javaClass.getDeclaredMethod(methodName, argumentTypes);
            return JavaMethod.create(runtime, method);
        }
        catch (NoSuchMethodException e) {
            throw runtime.newNameError("undefined method '" + methodName + "' for class '" + javaClass.getName() + "'", methodName);
        }
    }

    public RubyString name() {
        return this.getRuntime().newString(this.method.getName());
    }

    protected int getArity() {
        return this.method.getParameterTypes().length;
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.method.getModifiers()));
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.method.getModifiers()));
    }

    public IRubyObject invoke(IRubyObject[] args) {
        if (args.length != 1 + this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, 1 + this.getArity());
        }
        IRubyObject invokee = args[0];
        if (!(invokee instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("invokee not a java object");
        }
        Object javaInvokee = ((JavaObject)invokee).getValue();
        Object[] arguments = new Object[args.length - 1];
        System.arraycopy(args, 1, arguments, 0, arguments.length);
        this.convertArguments(arguments);
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw this.getRuntime().newTypeError("invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
        return this.invokeWithExceptionHandling(javaInvokee, arguments);
    }

    public IRubyObject invoke_static(IRubyObject[] args) {
        if (args.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, this.getArity());
        }
        Object[] arguments = new Object[args.length];
        System.arraycopy(args, 0, arguments, 0, arguments.length);
        this.convertArguments(arguments);
        return this.invokeWithExceptionHandling(null, arguments);
    }

    public IRubyObject return_type() {
        Class<?> klass = this.method.getReturnType();
        if (klass.equals(Void.TYPE)) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), klass);
    }

    private IRubyObject invokeWithExceptionHandling(Object javaInvokee, Object[] arguments) {
        try {
            Object result = this.method.invoke(javaInvokee, arguments);
            return JavaObject.wrap(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect());
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on '" + this.method.getName() + "': " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
            return this.getRuntime().getNil();
        }
    }

    private void convertArguments(Object[] arguments) {
        Class[] parameterTypes = this.parameterTypes();
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = JavaUtil.convertArgument(arguments[i], parameterTypes[i]);
        }
    }

    protected Class[] parameterTypes() {
        return this.method.getParameterTypes();
    }

    protected String nameOnInspection() {
        return "#<" + this.getType().toString() + "/" + this.method.getName() + "(";
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(this.isStatic());
    }

    private boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    protected int getModifiers() {
        return this.method.getModifiers();
    }

    protected AccessibleObject accesibleObject() {
        return this.method;
    }
}

