/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import org.jruby.ast.RegexpNode;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;

public class StringTerm
extends StrTerm {
    private int func;
    private final char term;
    private final char paren;
    private int nest;

    public StringTerm(int func, char term, char paren) {
        this.func = func;
        this.term = term;
        this.paren = paren;
        this.nest = 0;
    }

    public int parseString(RubyYaccLexer lexer, LexerSource src) {
        boolean space = false;
        if (this.func == -1) {
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 374;
        }
        char c = src.read();
        if ((this.func & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = src.read())) {
            }
            space = true;
        }
        if (c == this.term && this.nest == 0) {
            if ((this.func & 8) != 0) {
                this.func = -1;
                lexer.getPosition();
                return 32;
            }
            if ((this.func & 4) != 0) {
                lexer.setValue(new RegexpNode(src.getPosition(), "", this.parseRegexpFlags(src)));
                return 315;
            }
            lexer.setValue(new Token("\"", lexer.getPosition()));
            return 374;
        }
        if (space) {
            src.unread(c);
            lexer.getPosition();
            return 32;
        }
        StringBuffer buffer = lexer.getTokenBuffer();
        buffer.setLength(0);
        if ((this.func & 2) != 0 && c == '#') {
            c = src.read();
            switch (c) {
                case '$': 
                case '@': {
                    src.unread(c);
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 373;
                }
                case '{': {
                    lexer.setValue(new Token("#" + c, lexer.getPosition()));
                    return 372;
                }
            }
            buffer.append('#');
        }
        src.unread(c);
        if (this.parseStringIntoBuffer(src, buffer) == '\u0000') {
            throw new SyntaxException(src.getPosition(), "unterminated string meets end of file");
        }
        lexer.setValue(new StrNode(lexer.getPosition(), buffer.toString()));
        return 312;
    }

    private int parseRegexpFlags(LexerSource src) {
        int kcode = 0;
        int options = 0;
        StringBuffer unknownFlags = new StringBuffer(10);
        char c = src.read();
        while (c != '\u0000' && Character.isLetter(c)) {
            switch (c) {
                case 'i': {
                    options |= 1;
                    break;
                }
                case 'x': {
                    options |= 2;
                    break;
                }
                case 'm': {
                    options |= 4;
                    break;
                }
                case 'o': {
                    options |= 0x80;
                    break;
                }
                case 'n': {
                    kcode = 16;
                    break;
                }
                case 'e': {
                    kcode = 32;
                    break;
                }
                case 's': {
                    kcode = 48;
                    break;
                }
                case 'u': {
                    kcode = 64;
                    break;
                }
                default: {
                    unknownFlags.append(c);
                }
            }
            c = src.read();
        }
        src.unread(c);
        if (unknownFlags.length() != 0) {
            throw new SyntaxException(src.getPosition(), "unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + unknownFlags.toString());
        }
        return options | kcode;
    }

    public char parseStringIntoBuffer(LexerSource src, StringBuffer buffer) {
        char c;
        block4: while ((c = src.read()) != '\u0000') {
            block15: {
                block18: {
                    block17: {
                        block16: {
                            block14: {
                                if (this.paren == '\u0000' || c != this.paren) break block14;
                                ++this.nest;
                                break block15;
                            }
                            if (c != this.term) break block16;
                            if (this.nest == 0) {
                                src.unread(c);
                                break;
                            }
                            --this.nest;
                            break block15;
                        }
                        if ((this.func & 2) == 0 || c != '#' || src.peek('\n')) break block17;
                        char c2 = src.read();
                        if (c2 == '$' || c2 == '@' || c2 == '{') {
                            src.unread(c2);
                            src.unread(c);
                            break;
                        }
                        src.unread(c2);
                        break block15;
                    }
                    if (c != '\\') break block18;
                    c = src.read();
                    switch (c) {
                        case '\n': {
                            if ((this.func & 8) != 0) break;
                            if ((this.func & 2) != 0) continue block4;
                            buffer.append('\\');
                            break;
                        }
                        case '\\': {
                            if ((this.func & 1) != 0) {
                                buffer.append(c);
                                break;
                            }
                            break block15;
                        }
                        default: {
                            if ((this.func & 4) != 0) {
                                src.unread(c);
                                this.parseEscapeIntoBuffer(src, buffer);
                                continue block4;
                            }
                            if ((this.func & 2) != 0) {
                                src.unread(c);
                                if ((this.func & 1) != 0) {
                                    buffer.append('\\');
                                }
                                c = src.readEscape();
                                break;
                            }
                            if ((this.func & 8) != 0 && Character.isWhitespace(c)) break;
                            if (c != this.term && (this.paren == '\u0000' || c != this.paren)) {
                                buffer.append('\\');
                                break;
                            }
                            break block15;
                        }
                    }
                    break block15;
                }
                if ((this.func & 8) != 0 && Character.isWhitespace(c)) {
                    src.unread(c);
                    break;
                }
            }
            if (c == '\u0000' && (this.func & 0x10) != 0) {
                throw new SyntaxException(src.getPosition(), "symbol cannot contain '\\0'");
            }
            buffer.append(c);
        }
        return c;
    }

    private void escaped(LexerSource src, StringBuffer buffer) {
        char c = src.read();
        switch (c) {
            case '\\': {
                this.parseEscapeIntoBuffer(src, buffer);
                break;
            }
            case '\u0000': {
                throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(LexerSource src, StringBuffer buffer) {
        char c = src.read();
        block0 : switch (c) {
            case '\n': {
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                buffer.append('\\');
                buffer.append(c);
                for (int i = 0; i < 2; ++i) {
                    c = src.read();
                    if (c == '\u0000') {
                        throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                    }
                    if (!RubyYaccLexer.isOctChar(c)) {
                        src.unread(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 'x': {
                buffer.append('\\');
                buffer.append(c);
                c = src.read();
                if (!RubyYaccLexer.isHexChar(c)) {
                    throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                }
                buffer.append(c);
                c = src.read();
                if (RubyYaccLexer.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                src.unread(c);
                break;
            }
            case 'M': {
                c = src.read();
                if (c != '-') {
                    throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                }
                buffer.append("\\M-");
                this.escaped(src, buffer);
                break;
            }
            case 'C': {
                c = src.read();
                if (c != '-') {
                    throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
                }
                buffer.append("\\C-");
                this.escaped(src, buffer);
                break;
            }
            case 'c': {
                buffer.append("\\c");
                this.escaped(src, buffer);
                break;
            }
            case '\u0000': {
                throw new SyntaxException(src.getPosition(), "Invalid escape character syntax");
            }
            default: {
                if (c != '\\' || c != this.term) {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
        }
    }
}

