/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import org.jruby.IRuby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.runtime.Constants;
import org.jruby.runtime.load.Library;
import org.jruby.util.NormalizedFile;

public class RbConfigLibrary
implements Library {
    public void load(IRuby runtime) {
        RubyModule configModule = runtime.defineModule("Config");
        RubyHash configHash = RubyHash.newHash(runtime);
        configModule.defineConstant("CONFIG", configHash);
        String[] versionParts = Constants.RUBY_VERSION.split("\\.");
        RbConfigLibrary.setConfig(configHash, "MAJOR", versionParts[0]);
        RbConfigLibrary.setConfig(configHash, "MINOR", versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "TEENY", versionParts[2]);
        RbConfigLibrary.setConfig(configHash, "ruby_version", versionParts[0] + '.' + versionParts[1]);
        RbConfigLibrary.setConfig(configHash, "arch", "java");
        RbConfigLibrary.setConfig(configHash, "bindir", new NormalizedFile(System.getProperty("jruby.home"), "bin").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "RUBY_INSTALL_NAME", System.getProperty("jruby.script").replace('\\', '/'));
        RbConfigLibrary.setConfig(configHash, "ruby_install_name", System.getProperty("jruby.script").replace('\\', '/'));
        RbConfigLibrary.setConfig(configHash, "SHELL", System.getProperty("jruby.shell").replace('\\', '/'));
        RbConfigLibrary.setConfig(configHash, "prefix", new NormalizedFile(System.getProperty("jruby.home")).getAbsolutePath());
        String libdir = System.getProperty("jruby.lib");
        libdir = libdir == null ? new NormalizedFile(System.getProperty("jruby.home"), "lib").getAbsolutePath() : new NormalizedFile(libdir).getAbsolutePath();
        RbConfigLibrary.setConfig(configHash, "libdir", libdir);
        RbConfigLibrary.setConfig(configHash, "rubylibdir", new NormalizedFile(libdir, "ruby/1.8").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitedir", new NormalizedFile(libdir, "ruby/site_ruby").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitelibdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sitearchdir", new NormalizedFile(libdir, "ruby/site_ruby/1.8/java").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "configure_args", "");
        RbConfigLibrary.setConfig(configHash, "datadir", new NormalizedFile(System.getProperty("jruby.home"), "share").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "mandir", new NormalizedFile(System.getProperty("jruby.home"), "man").getAbsolutePath());
        RbConfigLibrary.setConfig(configHash, "sysconfdir", new NormalizedFile(System.getProperty("jruby.home"), "etc").getAbsolutePath());
        if (RbConfigLibrary.isWindows()) {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(configHash, "EXEEXT", "");
        }
    }

    private static void setConfig(RubyHash configHash, String key, String value) {
        IRuby runtime = configHash.getRuntime();
        configHash.aset(runtime.newString(key), runtime.newString(value));
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").startsWith("Windows");
    }
}

