/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.runtime.builtin.IRubyObject;

public final class Arity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map arities;
    private final int value;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Arity(int value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Arity createArity(int value) {
        Arity result;
        Integer integerValue = new Integer(value);
        Map map = arities;
        synchronized (map) {
            result = (Arity)arities.get(integerValue);
            if (result == null) {
                result = new Arity(value);
                arities.put(integerValue, result);
            }
        }
        return result;
    }

    public static Arity fixed(int arity) {
        if (!$assertionsDisabled && arity < 0) {
            throw new AssertionError();
        }
        return Arity.createArity(arity);
    }

    public static Arity optional() {
        return Arity.createArity(-1);
    }

    public static Arity required(int minimum) {
        if (!$assertionsDisabled && minimum < 0) {
            throw new AssertionError();
        }
        return Arity.createArity(-(1 + minimum));
    }

    public static Arity noArguments() {
        return Arity.createArity(0);
    }

    public static Arity singleArgument() {
        return Arity.createArity(1);
    }

    public static Arity twoArguments() {
        return Arity.createArity(2);
    }

    public int getValue() {
        return this.value;
    }

    public void checkArity(IRuby runtime, IRubyObject[] args) {
        if (this.isFixed() ? args.length != this.required() : args.length < this.required()) {
            throw runtime.newArgumentError("wrong number of arguments(" + args.length + " for " + this.required() + ")");
        }
    }

    public boolean isFixed() {
        return this.value >= 0;
    }

    private int required() {
        if (this.value < 0) {
            return -(1 + this.value);
        }
        return this.value;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        $assertionsDisabled = !Arity.class.desiredAssertionStatus();
        arities = new HashMap();
    }
}

