/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CallBlock
extends Block {
    private Arity arity;
    private BlockCallback callback;
    private IRubyObject self;
    private RubyModule imClass;
    private ThreadContext tc;

    public CallBlock(IRubyObject self, RubyModule imClass, Arity arity, BlockCallback callback, ThreadContext ctx) {
        super(null, new CallMethod(imClass, Visibility.PUBLIC, callback), self, ctx.getCurrentFrame(), ctx.peekCRef(), new Scope(), ctx.getRubyClass(), Iter.ITER_PRE, ctx.getCurrentScope());
        this.arity = arity;
        this.callback = callback;
        this.self = self;
        this.imClass = imClass;
        this.tc = ctx;
    }

    public IRubyObject call(IRubyObject[] args, IRubyObject replacementSelf) {
        return this.callback.call(args, replacementSelf);
    }

    public Block cloneBlock() {
        return new CallBlock(this.self, this.imClass, this.arity, this.callback, this.tc);
    }

    public Arity arity() {
        return this.arity;
    }

    public static class CallMethod
    extends AbstractMethod {
        private BlockCallback callback;

        public CallMethod(RubyModule implementationClass, Visibility visibility, BlockCallback callback) {
            super(implementationClass, visibility);
            this.callback = callback;
        }

        public void preMethod(ThreadContext context, RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
            context.preMethodCall(this.implementationClass, lastClass, recv, name, args, noSuper);
        }

        public void postMethod(ThreadContext context) {
            context.postMethodCall();
        }

        public IRubyObject internalCall(ThreadContext context, IRubyObject receiver, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
            return this.callback.call(args, receiver);
        }

        public ICallable dup() {
            return new CallMethod(this.getImplementationClass(), this.getVisibility(), this.callback);
        }
    }
}

