/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyThread;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.StarNode;
import org.jruby.ast.ZeroArgNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SourcePositionFactory;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Scope;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.SinglyLinkedList;

public class ThreadContext {
    private static final int INITIAL_SIZE = 50;
    private final IRuby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private Block blockStack;
    private RubyThread thread;
    private RubyModule[] parentStack = new RubyModule[50];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[50];
    private int frameIndex = -1;
    private Iter[] iterStack = new Iter[50];
    private int iterIndex = -1;
    private SinglyLinkedList[] crefStack = new SinglyLinkedList[50];
    private int crefIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[50];
    private int scopeIndex = -1;
    private String[] catchStack = new String[50];
    private int catchIndex = -1;
    private int[] bindingFrameStack = new int[50];
    private int bindingFrameIndex = -1;
    private RubyModule wrapper;
    private ISourcePosition sourcePosition = new SourcePositionFactory(null).getDummyPosition();
    Visibility lastVis;
    CallType lastCallType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ThreadContext(IRuby runtime) {
        this.runtime = runtime;
        this.pushScope(new DynamicScope(new LocalStaticScope(null), null));
    }

    public IRuby getRuntime() {
        return this.runtime;
    }

    public void setLastCallStatus(Visibility vis, CallType callType) {
        this.lastVis = vis;
        this.lastCallType = callType;
    }

    public Visibility getLastVisibility() {
        return this.lastVis;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    private void pushBlock(Block block) {
        block.setNext(this.blockStack);
        this.blockStack = block;
    }

    private Block popBlock() {
        if (this.blockStack == null) {
            return null;
        }
        Block current = this.blockStack;
        this.blockStack = (Block)this.blockStack.getNext();
        return current;
    }

    public Block getCurrentBlock() {
        return this.blockStack;
    }

    public boolean isBlockGiven() {
        return this.getCurrentFrame().isBlockGiven();
    }

    public boolean isFBlockGiven() {
        Frame previous = this.getPreviousFrame();
        if (previous == null) {
            return false;
        }
        return previous.isBlockGiven();
    }

    private void restoreBlockState(Block block, RubyModule klass) {
        this.pushFrame(block.getFrame());
        this.setCRef(block.getCRef());
        this.getCurrentFrame().setScope(block.getScope());
        if (block.getDynamicScope() != null) {
            this.pushScope(block.getDynamicScope().cloneScope());
        }
        this.pushRubyClass(klass != null ? klass : block.getKlass());
        this.pushIter(block.getIter());
    }

    private void flushBlockState(Block block) {
        this.popIter();
        if (block.getDynamicScope() != null) {
            this.popScope();
        }
        this.popFrame();
        this.unsetCRef();
        this.popRubyClass();
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    private void expandFramesIfNecessary() {
        if (this.frameIndex + 1 == this.frameStack.length) {
            int newSize = this.frameStack.length * 2;
            Frame[] newFrameStack = new Frame[newSize];
            System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
            this.frameStack = newFrameStack;
        }
    }

    private void expandParentsIfNecessary() {
        if (this.parentIndex + 1 == this.parentStack.length) {
            int newSize = this.parentStack.length * 2;
            RubyModule[] newParentStack = new RubyModule[newSize];
            System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
            this.parentStack = newParentStack;
        }
    }

    private void expandItersIfNecessary() {
        if (this.iterIndex + 1 == this.iterStack.length) {
            int newSize = this.iterStack.length * 2;
            Iter[] newIterStack = new Iter[newSize];
            System.arraycopy(this.iterStack, 0, newIterStack, 0, this.iterStack.length);
            this.iterStack = newIterStack;
        }
    }

    private void expandCrefsIfNecessary() {
        if (this.crefIndex + 1 == this.crefStack.length) {
            int newSize = this.crefStack.length * 2;
            SinglyLinkedList[] newCrefStack = new SinglyLinkedList[newSize];
            System.arraycopy(this.crefStack, 0, newCrefStack, 0, this.crefStack.length);
            this.crefStack = newCrefStack;
        }
    }

    public void pushScope(DynamicScope scope) {
        this.scopeStack[++this.scopeIndex] = scope;
        this.expandScopesIfNecessary();
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        if (this.scopeIndex + 1 == this.scopeStack.length) {
            int newSize = this.scopeStack.length * 2;
            DynamicScope[] newScopeStack = new DynamicScope[newSize];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
    }

    public IRubyObject getLastline() {
        return this.getCurrentScope().getLastLine();
    }

    public void setLastline(IRubyObject value) {
        this.getCurrentScope().setLastLine(value);
    }

    private void expandCatchIfNecessary() {
        if (this.catchIndex + 1 == this.catchStack.length) {
            int newSize = this.catchStack.length * 2;
            String[] newCatchStack = new String[newSize];
            System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
            this.catchStack = newCatchStack;
        }
    }

    public void pushCatch(String catchSymbol) {
        this.catchStack[++this.catchIndex] = catchSymbol;
        this.expandCatchIfNecessary();
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public String[] getActiveCatches() {
        if (this.catchIndex < 0) {
            return new String[0];
        }
        String[] activeCatches = new String[this.catchIndex + 1];
        System.arraycopy(this.catchStack, 0, activeCatches, 0, this.catchIndex + 1);
        return activeCatches;
    }

    private void pushFrameCopy() {
        this.pushFrame(this.getCurrentFrame().duplicate());
    }

    private void pushCallFrame(IRubyObject self, IRubyObject[] args, String lastFunc, RubyModule lastClass) {
        Iter iter = this.getCurrentFrame().getCallingZSuper() ? this.getCurrentFrame().getIter() : this.getCurrentIter();
        this.pushFrame(new Frame(this, self, args, lastFunc, lastClass, this.getPosition(), iter, this.getCurrentBlock()));
    }

    private void pushFrame() {
        this.pushFrame(new Frame(this, this.getCurrentIter(), this.getCurrentBlock()));
    }

    private void pushFrameNoBlock() {
        this.pushFrame(new Frame(this, Iter.ITER_NOT, null));
    }

    private void pushFrame(Frame frame) {
        this.frameStack[++this.frameIndex] = frame;
        this.expandFramesIfNecessary();
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex--];
        this.setPosition(frame.getPosition());
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public Frame getPreviousFrame() {
        int size = this.frameIndex + 1;
        return size <= 1 ? null : this.frameStack[size - 2];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public String getFrameLastFunc() {
        return this.getCurrentFrame().getLastFunc();
    }

    public Iter getFrameIter() {
        return this.getCurrentFrame().getIter();
    }

    public void setFrameIter(Iter iter) {
        this.getCurrentFrame().setIter(iter);
    }

    public Iter getPreviousFrameIter() {
        return this.getPreviousFrame().getIter();
    }

    public IRubyObject[] getFrameArgs() {
        return this.getCurrentFrame().getArgs();
    }

    public void setFrameArgs(IRubyObject[] args) {
        this.getCurrentFrame().setArgs(args);
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public void setFrameSelf(IRubyObject self) {
        this.getCurrentFrame().setSelf(self);
    }

    public IRubyObject getFramePreviousSelf() {
        return this.getPreviousFrame().getSelf();
    }

    public void setSelfToPrevious() {
        this.getCurrentFrame().setSelf(this.getPreviousFrame().getSelf());
    }

    public RubyModule getFrameLastClass() {
        return this.getCurrentFrame().getLastClass();
    }

    public RubyModule getPreviousFrameLastClass() {
        return this.getPreviousFrame().getLastClass();
    }

    public ISourcePosition getFramePosition() {
        return this.getCurrentFrame().getPosition();
    }

    public ISourcePosition getPreviousFramePosition() {
        return this.getPreviousFrame().getPosition();
    }

    private void expandBindingFrameIfNecessary() {
        if (this.bindingFrameIndex + 1 == this.bindingFrameStack.length) {
            int newSize = this.bindingFrameStack.length * 2;
            int[] newbindingFrameStack = new int[newSize];
            System.arraycopy(this.bindingFrameStack, 0, newbindingFrameStack, 0, this.bindingFrameStack.length);
            this.bindingFrameStack = newbindingFrameStack;
        }
    }

    public void pushBindingFrame(int bindingDepth) {
        this.bindingFrameStack[++this.bindingFrameIndex] = bindingDepth;
        this.expandBindingFrameIfNecessary();
    }

    public void popBindingFrame() {
        --this.bindingFrameIndex;
    }

    public int currentBindingFrame() {
        if (this.bindingFrameIndex == -1) {
            return 0;
        }
        return this.bindingFrameStack[this.bindingFrameIndex];
    }

    private Iter popIter() {
        Iter ret = this.iterStack[this.iterIndex];
        this.iterStack[this.iterIndex--] = null;
        return ret;
    }

    private void pushIter(Iter iter) {
        this.iterStack[++this.iterIndex] = iter;
        this.expandItersIfNecessary();
    }

    public void setNoBlock() {
        this.pushIter(Iter.ITER_NOT);
    }

    private void setNoBlockIfNoBlock() {
        this.pushIter(this.getCurrentIter().isNot() ? Iter.ITER_NOT : Iter.ITER_PRE);
    }

    public void clearNoBlock() {
        this.popIter();
    }

    public void setBlockAvailable() {
        this.pushIter(Iter.ITER_PRE);
    }

    public void clearBlockAvailable() {
        this.popIter();
    }

    public void setIfBlockAvailable() {
        this.pushIter(this.isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
    }

    public void clearIfBlockAvailable() {
        this.popIter();
    }

    public void setInBlockIfBlock() {
        this.pushIter(this.getCurrentIter().isPre() ? Iter.ITER_CUR : Iter.ITER_NOT);
    }

    public void setInBlock() {
        this.pushIter(Iter.ITER_CUR);
    }

    public void clearInBlock() {
        this.popIter();
    }

    public Iter getCurrentIter() {
        return this.iterStack[this.iterIndex];
    }

    public Scope getFrameScope() {
        return this.getCurrentFrame().getScope();
    }

    public ISourcePosition getPosition() {
        return this.sourcePosition;
    }

    public String getSourceFile() {
        return this.sourcePosition.getFile();
    }

    public int getSourceLine() {
        return this.sourcePosition.getEndLine();
    }

    public void setPosition(ISourcePosition position) {
        this.sourcePosition = position;
    }

    public IRubyObject getBackref() {
        IRubyObject value = this.getCurrentScope().getBackRef();
        return value == null ? this.runtime.getNil() : value;
    }

    public void setBackref(IRubyObject backref) {
        this.getCurrentScope().setBackRef(backref);
    }

    public Visibility getCurrentVisibility() {
        return this.getFrameScope().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getScope().getVisibility();
    }

    public void setCurrentVisibility(Visibility vis) {
        this.getFrameScope().setVisibility(vis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callSuper(IRubyObject[] args, boolean zSuper) {
        Frame frame = this.getCurrentFrame();
        frame.setCallingZSuper(zSuper);
        if (frame.getLastClass() == null) {
            String name = frame.getLastFunc();
            throw this.runtime.newNameError("superclass method '" + name + "' must be enabled by enableSuper().", name);
        }
        this.setNoBlockIfNoBlock();
        try {
            RubyClass superClass = frame.getLastClass().getSuperClass();
            if (superClass == null) {
                superClass = this.runtime.getClass("Module");
            }
            IRubyObject iRubyObject = frame.getSelf().callMethod(this, superClass, frame.getLastFunc(), args, CallType.SUPER);
            return iRubyObject;
        }
        finally {
            this.clearNoBlock();
            frame.setCallingZSuper(false);
        }
    }

    public IRubyObject callSuper(IRubyObject[] args) {
        return this.callSuper(args, false);
    }

    public IRubyObject yield(IRubyObject value) {
        return this.yieldCurrentBlock(value, null, null, false);
    }

    public IRubyObject yieldCurrentBlock(IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        if (!this.isBlockGiven()) {
            throw this.runtime.newLocalJumpError("yield called out of block");
        }
        Block currentBlock = this.preYieldCurrentBlock(klass);
        try {
            IRubyObject iRubyObject = this.yieldInternal(currentBlock, value, self, klass, aValue);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.NextJump) {
                IRubyObject nextValue = (IRubyObject)je.getPrimaryData();
                IRubyObject iRubyObject = nextValue == null ? this.runtime.getNil() : nextValue;
                return iRubyObject;
            }
            throw je;
        }
        finally {
            this.postYield(currentBlock);
        }
    }

    public IRubyObject yieldSpecificBlock(Block yieldBlock, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        this.preProcBlockCall();
        this.preYieldSpecificBlock(yieldBlock, klass);
        try {
            IRubyObject iRubyObject = this.yieldInternal(yieldBlock, value, self, klass, aValue);
            return iRubyObject;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.NextJump) {
                IRubyObject nextValue = (IRubyObject)je.getPrimaryData();
                IRubyObject iRubyObject = nextValue == null ? this.runtime.getNil() : nextValue;
                return iRubyObject;
            }
            throw je;
        }
        finally {
            this.postYield(yieldBlock);
            this.postProcBlockCall();
        }
    }

    private IRubyObject yieldInternal(Block yieldBlock, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue) {
        if (klass == null) {
            self = yieldBlock.getSelf();
        }
        IRubyObject[] args = this.getBlockArgs(value, self, false, aValue, yieldBlock);
        while (true) {
            try {
                IRubyObject result = yieldBlock.getMethod().call(this.runtime.getCurrentContext(), self, this.getCurrentFrame().getLastClass(), null, args, false);
                return result;
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.RedoJump) continue;
                throw je;
            }
            break;
        }
    }

    private IRubyObject[] getBlockArgs(IRubyObject value, IRubyObject self, boolean yieldProc, boolean aValue, Block currentBlock) {
        Node blockVar = currentBlock.getVar();
        if (blockVar == null) {
            return new IRubyObject[]{value};
        }
        if (blockVar instanceof ZeroArgNode) {
            if (yieldProc && this.arrayLength(value) != 0) {
                throw this.runtime.newArgumentError("wrong # of arguments(" + ((RubyArray)value).getLength() + "for 0)");
            }
        } else if (blockVar instanceof MultipleAsgnNode) {
            if (!aValue) {
                value = this.sValueToMRHS(value, ((MultipleAsgnNode)blockVar).getHeadNode());
            }
            value = this.mAssign(self, (MultipleAsgnNode)blockVar, (RubyArray)value, yieldProc);
        } else {
            if (aValue) {
                int length = this.arrayLength(value);
                if (length == 0) {
                    value = this.runtime.getNil();
                } else if (length == 1) {
                    value = ((RubyArray)value).first(IRubyObject.NULL_ARRAY);
                } else {
                    this.runtime.getWarnings().warn("multiple values for a block parameter (" + length + " for 1)");
                }
            } else if (value == null) {
                this.runtime.getWarnings().warn("multiple values for a block parameter (0 for 1)");
            }
            AssignmentVisitor.assign(this, this.getFrameSelf(), blockVar, value, yieldProc);
        }
        return ArgsUtil.arrayify(value);
    }

    public IRubyObject mAssign(IRubyObject self, MultipleAsgnNode node, RubyArray value, boolean pcall) {
        int valueLen = value.getLength();
        int varLen = node.getHeadNode() == null ? 0 : node.getHeadNode().size();
        Iterator iter = node.getHeadNode() != null ? node.getHeadNode().iterator() : Collections.EMPTY_LIST.iterator();
        for (int i = 0; i < valueLen && iter.hasNext(); ++i) {
            Node lNode = (Node)iter.next();
            AssignmentVisitor.assign(this, this.getFrameSelf(), lNode, value.entry(i), pcall);
        }
        if (pcall && iter.hasNext()) {
            throw this.runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        if (node.getArgsNode() != null) {
            if (!(node.getArgsNode() instanceof StarNode)) {
                if (varLen < valueLen) {
                    ArrayList newList = new ArrayList(value.getList().subList(varLen, valueLen));
                    AssignmentVisitor.assign(this, this.getFrameSelf(), node.getArgsNode(), this.runtime.newArray(newList), pcall);
                } else {
                    AssignmentVisitor.assign(this, this.getFrameSelf(), node.getArgsNode(), this.runtime.newArray(0), pcall);
                }
            }
        } else if (pcall && valueLen < varLen) {
            throw this.runtime.newArgumentError("Wrong # of arguments (" + valueLen + " for " + varLen + ")");
        }
        while (iter.hasNext()) {
            AssignmentVisitor.assign(this, this.getFrameSelf(), (Node)iter.next(), this.runtime.getNil(), pcall);
        }
        return value;
    }

    private IRubyObject sValueToMRHS(IRubyObject value, Node leftHandSide) {
        if (value == null) {
            return this.runtime.newArray(0);
        }
        if (leftHandSide == null) {
            return this.runtime.newArray(value);
        }
        IRubyObject newValue = value.convertToType("Array", "to_ary", false);
        if (newValue.isNil()) {
            return this.runtime.newArray(value);
        }
        return newValue;
    }

    private int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public void pollThreadEvents() {
        this.getThread().pollThreadEvents();
    }

    public SinglyLinkedList peekCRef() {
        return this.crefStack[this.crefIndex];
    }

    public void setCRef(SinglyLinkedList newCRef) {
        this.crefStack[++this.crefIndex] = newCRef;
        this.expandCrefsIfNecessary();
    }

    public void unsetCRef() {
        this.crefStack[this.crefIndex--] = null;
    }

    public SinglyLinkedList pushCRef(RubyModule newModule) {
        if (this.crefIndex == -1) {
            this.crefStack[++this.crefIndex] = new SinglyLinkedList(newModule, null);
        } else {
            this.crefStack[this.crefIndex] = new SinglyLinkedList(newModule, this.crefStack[this.crefIndex]);
        }
        return this.peekCRef();
    }

    public RubyModule popCRef() {
        SinglyLinkedList next;
        if (!$assertionsDisabled && this.crefIndex == -1) {
            throw new AssertionError((Object)"Tried to pop from empty CRef stack");
        }
        RubyModule module = (RubyModule)this.peekCRef().getValue();
        if ((next = this.crefStack[this.crefIndex--].getNext()) != null) {
            this.crefStack[++this.crefIndex] = next;
        } else {
            this.crefStack[this.crefIndex + 1] = null;
        }
        return module;
    }

    public void pushRubyClass(RubyModule currentModule) {
        if (!$assertionsDisabled && currentModule == null) {
            throw new AssertionError((Object)"Can't push null RubyClass");
        }
        this.parentStack[++this.parentIndex] = currentModule;
        this.expandParentsIfNecessary();
    }

    public RubyModule popRubyClass() {
        RubyModule ret = this.parentStack[this.parentIndex];
        this.parentStack[this.parentIndex--] = null;
        return ret;
    }

    public RubyModule getRubyClass() {
        if (!$assertionsDisabled && this.parentIndex == -1) {
            throw new AssertionError((Object)"Trying to get RubyClass from empty stack");
        }
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(RubyModule wrapper) {
        this.wrapper = wrapper;
    }

    public boolean getConstantDefined(String name) {
        IRubyObject result = null;
        for (SinglyLinkedList cbase = this.peekCRef(); cbase != null; cbase = cbase.getNext()) {
            result = ((RubyModule)cbase.getValue()).getConstantAt(name);
            if (result == null && this.runtime.getLoadService().autoload(name) == null) continue;
            return true;
        }
        return false;
    }

    public IRubyObject getConstant(String name) {
        SinglyLinkedList cbase = this.peekCRef();
        IRubyObject result = null;
        do {
            RubyModule klass;
            if ((result = (klass = (RubyModule)cbase.getValue()).getConstantAt(name)) == null) {
                if (this.runtime.getLoadService().autoload(name) != null) {
                    continue;
                }
            } else {
                return result;
            }
            cbase = cbase.getNext();
        } while (cbase != null);
        return ((RubyModule)this.peekCRef().getValue()).getConstant(name);
    }

    private void addBackTraceElement(RubyArray backtrace, Frame frame, Frame previousFrame) {
        StringBuffer sb = new StringBuffer(100);
        ISourcePosition position = frame.getPosition();
        sb.append(position.getFile()).append(':').append(position.getEndLine());
        if (previousFrame != null && previousFrame.getLastFunc() != null) {
            sb.append(":in `").append(previousFrame.getLastFunc()).append('\'');
        } else if (previousFrame == null && frame.getLastFunc() != null) {
            sb.append(":in `").append(frame.getLastFunc()).append('\'');
        }
        backtrace.append(backtrace.getRuntime().newString(sb.toString()));
    }

    public IRubyObject createBacktrace(int level, boolean nativeException) {
        RubyArray backtrace = this.runtime.newArray();
        int base = this.currentBindingFrame();
        int traceSize = this.frameIndex - level;
        if (traceSize <= 0) {
            return backtrace;
        }
        if (nativeException) {
            this.addBackTraceElement(backtrace, this.frameStack[this.frameIndex], null);
        }
        for (int i = traceSize; i > this.currentBindingFrame(); --i) {
            this.addBackTraceElement(backtrace, this.frameStack[i], this.frameStack[i - 1]);
        }
        return backtrace;
    }

    public void beginCallArgs() {
        this.setNoBlock();
    }

    public void endCallArgs() {
        this.clearNoBlock();
    }

    public void preAdoptThread() {
        this.setNoBlock();
        this.pushFrameNoBlock();
        this.getCurrentFrame().newScope();
        this.pushRubyClass(this.runtime.getObject());
        this.pushCRef(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preClassEval(StaticScope staticScope, RubyModule type) {
        this.pushCRef(type);
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().newScope();
        this.pushScope(new DynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postClassEval() {
        this.popCRef();
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names);
        this.pushFrameNoBlock();
        this.getCurrentFrame().newScope();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodCall(RubyModule implementationClass, RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
        this.pushRubyClass((RubyModule)implementationClass.getCRef().getValue());
        this.setInBlockIfBlock();
        this.pushCallFrame(recv, args, name, noSuper ? null : lastClass);
    }

    public void postMethodCall() {
        this.popFrame();
        this.clearInBlock();
        this.popRubyClass();
    }

    public void preDefMethodInternalCall(RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper, SinglyLinkedList cref, StaticScope staticScope) {
        RubyModule implementationClass = (RubyModule)cref.getValue();
        this.setCRef(cref);
        this.setInBlockIfBlock();
        this.pushCallFrame(recv, args, name, noSuper ? null : lastClass);
        this.getCurrentFrame().newScope();
        this.pushScope(new DynamicScope(staticScope, this.getCurrentScope()));
        this.pushRubyClass(implementationClass);
    }

    public void postDefMethodInternalCall() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
        this.clearInBlock();
        this.unsetCRef();
    }

    public void preReflectedMethodInternalCall(RubyModule implementationClass, RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
        this.pushRubyClass((RubyModule)implementationClass.getCRef().getValue());
        this.setInBlockIfBlock();
        this.pushCallFrame(recv, args, name, noSuper ? null : lastClass);
        this.getCurrentFrame().setScope(this.getPreviousFrame().getScope());
    }

    public void postReflectedMethodInternalCall() {
        this.popFrame();
        this.clearInBlock();
        this.popRubyClass();
    }

    public void preInitCoreClasses() {
        this.setNoBlock();
        this.pushFrameNoBlock();
        this.getCurrentFrame().newScope();
        this.setCurrentVisibility(Visibility.PRIVATE);
    }

    public void preInitBuiltinClasses(RubyClass objectClass, IRubyObject topSelf) {
        this.pushRubyClass(objectClass);
        this.setCRef(objectClass.getCRef());
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
    }

    public void preNodeEval(RubyModule newWrapper, RubyModule rubyClass, IRubyObject self) {
        this.setWrapper(newWrapper);
        this.pushRubyClass(rubyClass);
        this.pushCallFrame(self, IRubyObject.NULL_ARRAY, null, null);
        this.setCRef(rubyClass.getCRef());
    }

    public void postNodeEval(RubyModule newWrapper) {
        this.popFrame();
        this.popRubyClass();
        this.setWrapper(newWrapper);
        this.unsetCRef();
    }

    public void preExecuteUnder(RubyModule executeUnderClass) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        this.pushCRef(executeUnderClass);
        this.pushCallFrame(null, frame.getArgs(), frame.getLastFunc(), frame.getLastClass());
        this.getCurrentFrame().setScope(this.getPreviousFrame().getScope());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popRubyClass();
        this.popCRef();
    }

    public void preMproc() {
        this.setInBlock();
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
        this.clearInBlock();
    }

    public void preRunThread(Frame currentFrame, Block currentBlock) {
        this.pushFrame(currentFrame);
        this.blockStack = currentBlock;
    }

    public void preTrace() {
        this.pushFrameNoBlock();
    }

    public void postTrace() {
        this.popFrame();
    }

    public void preBlockPassEval(Block block) {
        this.pushBlock(block);
        this.setBlockAvailable();
    }

    public void postBlockPassEval() {
        this.clearBlockAvailable();
        this.popBlock();
    }

    public void preForLoopEval(Block block) {
        this.pushBlock(block);
        this.setBlockAvailable();
    }

    public void postForLoopEval() {
        this.clearBlockAvailable();
        this.popBlock();
    }

    public void preIterEval(Block block) {
        this.pushBlock(block);
    }

    public void postIterEval() {
        this.popBlock();
    }

    public void preToProc(Block block) {
        this.setBlockAvailable();
        this.pushBlock(block);
    }

    public void postToProc() {
        this.clearBlockAvailable();
        this.popBlock();
    }

    public void preProcBlockCall() {
        this.setInBlock();
        this.getCurrentFrame().setIter(Iter.ITER_CUR);
    }

    public void postProcBlockCall() {
        this.clearInBlock();
    }

    private Block preYieldCurrentBlock(RubyModule klass) {
        Block currentBlock = this.getCurrentFrame().getBlockArg();
        this.restoreBlockState(currentBlock, klass);
        return currentBlock;
    }

    private void preYieldSpecificBlock(Block specificBlock, RubyModule klass) {
        this.restoreBlockState(specificBlock, klass);
    }

    public void preEvalWithBinding(Block block) {
        this.pushBindingFrame(this.frameIndex);
        this.pushFrame(block.getFrame());
        this.setCRef(block.getCRef());
        this.getCurrentFrame().setScope(block.getScope());
        this.pushRubyClass(block.getKlass());
        this.pushIter(block.getIter());
    }

    public void postEvalWithBinding(Block block) {
        this.popIter();
        this.popFrame();
        this.unsetCRef();
        this.popRubyClass();
        this.popBindingFrame();
    }

    public void postYield(Block block) {
        this.flushBlockState(block);
    }

    public void preRootNode(DynamicScope scope) {
        this.pushScope(scope);
        this.getCurrentFrame().newScope();
    }

    public void postRootNode() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }

    static {
        $assertionsDisabled = !ThreadContext.class.desiredAssertionStatus();
    }
}

