/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubySymbol;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.IntegerMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class FixnumMetaClass
extends IntegerMetaClass {
    public FixnumMetaClass(IRuby runtime) {
        super("Fixnum", RubyFixnum.class, runtime.getClass("Integer"));
    }

    public FixnumMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyFixnum.class, superClass, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new FixnumMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new FixnumMetaClass(name, (RubyClass)this, parentCRef);
    }

    public RubyInteger induced_from(IRubyObject number) {
        if (number instanceof RubySymbol) {
            return (RubyInteger)number.callMethod(this.getRuntime().getCurrentContext(), "to_i");
        }
        return ((IntegerMetaClass)this.getRuntime().getClass("Integer")).induced_from(number);
    }

    protected class FixnumMeta
    extends AbstractMetaClass.Meta {
        protected FixnumMeta() {
        }

        protected void initializeClass() {
            FixnumMetaClass.this.defineMethod("quo", Arity.singleArgument());
            FixnumMetaClass.this.defineMethod("to_f", Arity.noArguments());
            FixnumMetaClass.this.defineMethod("to_i", Arity.noArguments());
            FixnumMetaClass.this.defineMethod("to_s", Arity.optional());
            FixnumMetaClass.this.defineMethod("taint", Arity.noArguments());
            FixnumMetaClass.this.defineMethod("freeze", Arity.noArguments());
            FixnumMetaClass.this.defineMethod("<<", Arity.singleArgument(), "op_lshift");
            FixnumMetaClass.this.defineMethod(">>", Arity.singleArgument(), "op_rshift");
            FixnumMetaClass.this.defineMethod("+", Arity.singleArgument(), "op_plus");
            FixnumMetaClass.this.defineMethod("-", Arity.singleArgument(), "op_minus");
            FixnumMetaClass.this.defineMethod("*", Arity.singleArgument(), "op_mul");
            FixnumMetaClass.this.defineMethod("/", Arity.singleArgument(), "op_div");
            FixnumMetaClass.this.defineAlias("div", "/");
            FixnumMetaClass.this.defineMethod("%", Arity.singleArgument(), "op_mod");
            FixnumMetaClass.this.defineMethod("**", Arity.singleArgument(), "op_pow");
            FixnumMetaClass.this.defineMethod("&", Arity.singleArgument(), "op_and");
            FixnumMetaClass.this.defineMethod("|", Arity.singleArgument(), "op_or");
            FixnumMetaClass.this.defineMethod("^", Arity.singleArgument(), "op_xor");
            FixnumMetaClass.this.defineMethod("size", Arity.noArguments());
            FixnumMetaClass.this.defineMethod("[]", Arity.singleArgument(), "aref");
            FixnumMetaClass.this.defineMethod("hash", Arity.noArguments());
            FixnumMetaClass.this.defineMethod("id2name", Arity.noArguments());
            FixnumMetaClass.this.defineMethod("~", Arity.noArguments(), "invert");
            FixnumMetaClass.this.defineMethod("id", Arity.noArguments());
            FixnumMetaClass.this.defineSingletonMethod("induced_from", Arity.singleArgument(), "induced_from");
        }
    }
}

