/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import java.util.HashMap;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class HashMetaClass
extends ObjectMetaClass {
    public HashMetaClass(IRuby runtime) {
        super("Hash", RubyHash.class, runtime.getObject());
    }

    public HashMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyHash.class, superClass, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new HashMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new HashMetaClass(name, (RubyClass)this, parentCRef);
    }

    protected IRubyObject allocateObject() {
        RubyHash instance = new RubyHash(this.getRuntime());
        instance.setMetaClass(this);
        return instance;
    }

    public IRubyObject newInstance(IRubyObject[] args) {
        IRuby runtime = this.getRuntime();
        RubyHash hash = (RubyHash)this.allocateObject();
        if (runtime.getCurrentContext().isBlockGiven()) {
            hash.setDefaultProc(runtime.newProc());
        }
        hash.setMetaClass(this);
        hash.callInit(args);
        return hash;
    }

    public IRubyObject create(IRubyObject[] args) {
        RubyHash hash = (RubyHash)this.allocateObject();
        if (args.length == 1) {
            hash.setValueMap(new HashMap(((RubyHash)args[0]).getValueMap()));
        } else {
            if (args.length % 2 != 0) {
                throw this.getRuntime().newArgumentError("odd number of args for Hash");
            }
            for (int i = 0; i < args.length; i += 2) {
                hash.aset(args[i], args[i + 1]);
            }
        }
        return hash;
    }

    protected class HashMeta
    extends AbstractMetaClass.Meta {
        protected HashMeta() {
        }

        protected void initializeClass() {
            HashMetaClass.this.includeModule(HashMetaClass.this.getRuntime().getModule("Enumerable"));
            HashMetaClass.this.defineMethod("==", Arity.singleArgument(), "equal");
            HashMetaClass.this.defineMethod("[]", Arity.singleArgument(), "aref");
            HashMetaClass.this.defineMethod("[]=", Arity.twoArguments(), "aset");
            HashMetaClass.this.defineMethod("clear", Arity.noArguments(), "rb_clear");
            HashMetaClass.this.defineMethod("clone", Arity.noArguments(), "rbClone");
            HashMetaClass.this.defineMethod("default", Arity.optional(), "getDefaultValue");
            HashMetaClass.this.defineMethod("default_proc", Arity.noArguments());
            HashMetaClass.this.defineMethod("default=", Arity.singleArgument(), "setDefaultValue");
            HashMetaClass.this.defineMethod("delete", Arity.singleArgument());
            HashMetaClass.this.defineMethod("delete_if", Arity.noArguments());
            HashMetaClass.this.defineMethod("each", Arity.noArguments());
            HashMetaClass.this.defineMethod("each_pair", Arity.noArguments());
            HashMetaClass.this.defineMethod("each_value", Arity.noArguments());
            HashMetaClass.this.defineMethod("each_key", Arity.noArguments());
            HashMetaClass.this.defineMethod("empty?", Arity.noArguments(), "empty_p");
            HashMetaClass.this.defineMethod("fetch", Arity.optional());
            HashMetaClass.this.defineMethod("has_value?", Arity.singleArgument(), "has_value");
            HashMetaClass.this.defineMethod("index", Arity.singleArgument());
            HashMetaClass.this.defineMethod("indices", Arity.optional());
            HashMetaClass.this.defineMethod("initialize", Arity.optional());
            HashMetaClass.this.defineMethod("inspect", Arity.noArguments());
            HashMetaClass.this.defineMethod("invert", Arity.noArguments());
            HashMetaClass.this.defineMethod("include?", Arity.singleArgument(), "has_key");
            HashMetaClass.this.defineMethod("keys", Arity.noArguments());
            HashMetaClass.this.defineMethod("merge", Arity.singleArgument());
            HashMetaClass.this.defineMethod("rehash", Arity.noArguments());
            HashMetaClass.this.defineMethod("reject", Arity.noArguments());
            HashMetaClass.this.defineMethod("reject!", Arity.noArguments(), "reject_bang");
            HashMetaClass.this.defineMethod("replace", Arity.singleArgument());
            HashMetaClass.this.defineMethod("shift", Arity.noArguments());
            HashMetaClass.this.defineMethod("size", Arity.noArguments(), "rb_size");
            HashMetaClass.this.defineMethod("sort", Arity.noArguments());
            HashMetaClass.this.defineMethod("to_a", Arity.noArguments());
            HashMetaClass.this.defineMethod("to_hash", Arity.noArguments());
            HashMetaClass.this.defineMethod("to_s", Arity.noArguments());
            HashMetaClass.this.defineMethod("update", Arity.singleArgument());
            HashMetaClass.this.defineMethod("values", Arity.noArguments(), "rb_values");
            HashMetaClass.this.defineMethod("values_at", Arity.optional());
            HashMetaClass.this.defineAlias("has_key?", "include?");
            HashMetaClass.this.defineAlias("indexes", "indices");
            HashMetaClass.this.defineAlias("key?", "include?");
            HashMetaClass.this.defineAlias("length", "size");
            HashMetaClass.this.defineAlias("member?", "include?");
            HashMetaClass.this.defineAlias("merge!", "update");
            HashMetaClass.this.defineAlias("store", "[]=");
            HashMetaClass.this.defineAlias("value?", "has_value?");
            HashMetaClass.this.defineSingletonMethod("new", Arity.optional(), "newInstance");
            HashMetaClass.this.defineSingletonMethod("[]", Arity.optional(), "create");
        }
    }
}

