/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.IRuby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.NumericMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class IntegerMetaClass
extends NumericMetaClass {
    public IntegerMetaClass(IRuby runtime) {
        super("Integer", RubyInteger.class, runtime.getClass("Numeric"));
    }

    public IntegerMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyInteger.class, superClass, parentCRef);
    }

    public IntegerMetaClass(String name, Class clazz, RubyClass superClass) {
        super(name, clazz, superClass);
    }

    public IntegerMetaClass(String name, Class clazz, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, clazz, superClass, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new IntegerMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new IntegerMetaClass(name, (RubyClass)this, parentCRef);
    }

    protected IRubyObject allocateObject() {
        return null;
    }

    public RubyInteger induced_from(IRubyObject number) {
        if (number instanceof RubyFixnum) {
            return (RubyFixnum)number;
        }
        if (number instanceof RubyFloat) {
            return ((RubyFloat)number).to_i();
        }
        if (number instanceof RubyBignum) {
            return this.getRuntime().newFixnum(((RubyBignum)number).getLongValue());
        }
        throw this.getRuntime().newTypeError("failed to convert " + number.getMetaClass() + " into Integer");
    }

    protected class IntegerMeta
    extends AbstractMetaClass.Meta {
        protected IntegerMeta() {
        }

        protected void initializeClass() {
            IntegerMetaClass.this.includeModule(IntegerMetaClass.this.getRuntime().getModule("Precision"));
            IntegerMetaClass.this.defineMethod("chr", Arity.noArguments());
            IntegerMetaClass.this.defineMethod("downto", Arity.singleArgument());
            IntegerMetaClass.this.defineMethod("integer?", Arity.noArguments(), "int_p");
            IntegerMetaClass.this.defineMethod("next", Arity.noArguments());
            IntegerMetaClass.this.defineMethod("step", Arity.twoArguments());
            IntegerMetaClass.this.defineAlias("succ", "next");
            IntegerMetaClass.this.defineMethod("times", Arity.noArguments());
            IntegerMetaClass.this.defineMethod("upto", Arity.singleArgument());
            IntegerMetaClass.this.getSingletonClass().undefineMethod("new");
            IntegerMetaClass.this.defineSingletonMethod("induced_from", Arity.singleArgument());
        }
    }
}

