/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.jruby.IRuby;
import org.jruby.runtime.Constants;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.ExternalScript;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.JarredScript;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.util.BuiltinScript;
import org.jruby.util.JRubyFile;
import org.jruby.util.PreparsedScript;

public class LoadService {
    private static final String JRUBY_BUILTIN_SUFFIX = ".rb";
    private static final String[] suffixes = new String[]{".rb", ".ast.ser", ".rb.ast.ser", ".jar"};
    private static final Pattern suffixPattern = Pattern.compile("^(.*)\\.(jrb|ast\\.ser|rb\\.ast\\.ser|rb|jar)$");
    private final List loadPath = new ArrayList();
    private final Set loadedFeatures = Collections.synchronizedSet(new HashSet());
    private final Set loadedFeaturesInternal = Collections.synchronizedSet(new HashSet());
    private final Map builtinLibraries = new HashMap();
    private final Map jarFiles = new HashMap();
    private final Map autoloadMap = new HashMap();
    private final IRuby runtime;

    public LoadService(IRuby runtime) {
        this.runtime = runtime;
    }

    public void init(List additionalDirectories) {
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.addPath((String)iter.next());
        }
        try {
            String jrubyHome;
            String jrubyLib;
            if (this.runtime.getSafeLevel() == 0 && (jrubyLib = System.getProperty("jruby.lib")) != null) {
                this.addPath(jrubyLib);
            }
            if ((jrubyHome = System.getProperty("jruby.home")) != null) {
                char sep = '/';
                String rubyDir = jrubyHome + sep + "lib" + sep + "ruby" + sep;
                this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY_MAJOR_VERSION);
                this.addPath(rubyDir + "site_ruby" + sep + Constants.RUBY_MAJOR_VERSION + sep + "java");
                this.addPath(rubyDir + "site_ruby");
                this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION);
                this.addPath(rubyDir + Constants.RUBY_MAJOR_VERSION + sep + "java");
                this.addPath("lib" + sep + "ruby" + sep + Constants.RUBY_MAJOR_VERSION);
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        if (this.runtime.getSafeLevel() == 0) {
            this.addPath(".");
        }
    }

    private void addPath(String path) {
        this.loadPath.add(this.runtime.newString(path.replace('\\', '/')));
    }

    public void load(String file) {
        Library library = null;
        library = this.findLibrary(file);
        if (library == null) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        try {
            library.load(this.runtime);
        }
        catch (IOException e) {
            throw this.runtime.newLoadError("IO error -- " + file);
        }
    }

    public void smartLoad(String file) {
        Library library = null;
        String loadName = file;
        for (int i = 0; i < suffixes.length; ++i) {
            library = this.findLibrary(file + suffixes[i]);
            if (library == null) continue;
            loadName = file + suffixes[i];
            break;
        }
        if (library == null && (library = this.findLibrary(file)) != null) {
            loadName = file;
        }
        if ((library = this.tryLoadExtension(library, file)) == null) {
            throw this.runtime.newLoadError("No such file to load -- " + file);
        }
        try {
            this.loadedFeaturesInternal.add(file);
            this.loadedFeatures.add(this.runtime.newString(loadName));
            library.load(this.runtime);
        }
        catch (IOException e) {
            this.loadedFeaturesInternal.remove(file);
            this.loadedFeatures.remove(this.runtime.newString(loadName));
            throw this.runtime.newLoadError("IO error -- " + file);
        }
    }

    private Library tryLoadExtension(Library library, String file) {
        Library oldLibrary = library;
        if (library == null || library instanceof JarredScript) {
            String[] all = file.split("/");
            StringBuffer finName = new StringBuffer();
            int j = all.length - 1;
            for (int i = 0; i < j; ++i) {
                finName.append(all[i].toLowerCase()).append(".");
            }
            String[] last = all[all.length - 1].split("_");
            int j2 = last.length;
            for (int i = 0; i < j2; ++i) {
                finName.append(Character.toUpperCase(last[i].charAt(0))).append(last[i].substring(1));
            }
            finName.append("Service");
            String className = finName.toString().replaceAll("^\\.*", "");
            if (library instanceof JarredScript) {
                this.runtime.getJavaSupport().addToClasspath(((JarredScript)library).getResource().getURL());
            }
            try {
                Class theClass = this.runtime.getJavaSupport().loadJavaClass(className);
                library = new ClassExtensionLibrary(theClass);
            }
            catch (Exception ee) {
                library = null;
            }
        }
        if (library == null && oldLibrary != null) {
            library = oldLibrary;
        }
        return library;
    }

    private Library findLibrary(String file) {
        if (this.builtinLibraries.containsKey(file)) {
            return (Library)this.builtinLibraries.get(file);
        }
        LoadServiceResource resource = this.findFile(file);
        if (resource == null) {
            return null;
        }
        if (file.endsWith(".jar")) {
            return new JarredScript(resource);
        }
        if (file.endsWith(".rb.ast.ser")) {
            return new PreparsedScript(resource);
        }
        return new ExternalScript(resource, file);
    }

    public boolean require(String file) {
        String filestr = suffixPattern.matcher(file).replaceAll("$1");
        if (this.loadedFeaturesInternal.contains(filestr)) {
            return false;
        }
        this.smartLoad(filestr);
        return true;
    }

    public List getLoadPath() {
        return this.loadPath;
    }

    public Set getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public boolean isAutoloadDefined(String name) {
        return this.autoloadMap.containsKey(name);
    }

    public IAutoloadMethod autoloadFor(String name) {
        return (IAutoloadMethod)this.autoloadMap.get(name);
    }

    public IRubyObject autoload(String name) {
        IAutoloadMethod loadMethod = (IAutoloadMethod)this.autoloadMap.remove(name);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name);
        }
        return null;
    }

    public void addAutoload(String name, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name, loadMethod);
    }

    public void registerBuiltin(String name, Library library) {
        this.builtinLibraries.put(name, library);
    }

    private LoadServiceResource findFile(String name) {
        URL loc;
        if (name.startsWith("jar:")) {
            try {
                return new LoadServiceResource(new URL(name), name);
            }
            catch (MalformedURLException e) {
                throw this.runtime.newIOErrorFromException(e);
            }
        }
        try {
            JRubyFile file = JRubyFile.create(this.runtime.getCurrentDirectory(), name);
            if (file.isFile() && file.isAbsolute()) {
                try {
                    return new LoadServiceResource(file.toURL(), name);
                }
                catch (MalformedURLException e) {
                    throw this.runtime.newIOErrorFromException(e);
                }
            }
        }
        catch (AccessControlException accessEx) {
        }
        catch (IllegalArgumentException illArgEx) {
            // empty catch block
        }
        ClassLoader classLoader = this.runtime.getJavaSupport().getJavaClassLoader();
        String xname = name.replace('\\', '/');
        if (xname.charAt(0) == '/' && this.isRequireable(loc = classLoader.getResource(xname))) {
            return new LoadServiceResource(loc, loc.getPath());
        }
        Iterator pathIter = this.loadPath.iterator();
        while (pathIter.hasNext()) {
            URL loc2;
            Object current;
            String entry = pathIter.next().toString();
            if (entry.startsWith("jar:")) {
                current = (JarFile)this.jarFiles.get(entry);
                if (null == current) {
                    try {
                        current = new JarFile(entry.substring(4));
                        this.jarFiles.put(entry, current);
                    }
                    catch (FileNotFoundException ignored) {
                    }
                    catch (IOException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
                if (((JarFile)current).getJarEntry(name) != null) {
                    try {
                        return new LoadServiceResource(new URL(entry + name), entry + name);
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
            }
            try {
                current = JRubyFile.create(JRubyFile.create(this.runtime.getCurrentDirectory(), entry).getAbsolutePath(), name);
                if (((File)current).isFile()) {
                    try {
                        return new LoadServiceResource(((File)current).toURL(), ((JRubyFile)current).getPath());
                    }
                    catch (MalformedURLException e) {
                        throw this.runtime.newIOErrorFromException(e);
                    }
                }
            }
            catch (AccessControlException accessEx) {
            }
            catch (IllegalArgumentException illArgEx) {
                // empty catch block
            }
            if (!this.isRequireable(loc2 = classLoader.getResource(entry.replace('\\', '/') + "/" + xname))) continue;
            return new LoadServiceResource(loc2, loc2.getPath());
        }
        loc = classLoader.getResource(xname);
        return this.isRequireable(loc) ? new LoadServiceResource(loc, loc.getPath()) : null;
    }

    private boolean isRequireable(URL loc) {
        if (loc != null) {
            if (loc.getProtocol().equals("file") && new File(loc.getFile()).isDirectory()) {
                return false;
            }
            try {
                loc.openConnection();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void registerRubyBuiltin(String libraryName) {
        this.registerBuiltin(libraryName + JRUBY_BUILTIN_SUFFIX, new BuiltinScript(libraryName));
    }
}

