/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.jruby.IRuby;
import org.jruby.RubyIO;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerJavaIO;
import org.jruby.util.IOModes;
import org.jruby.util.RubyInputStream;

public class IOHandlerUnseekable
extends IOHandlerJavaIO {
    protected InputStream input = null;
    protected OutputStream output = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IOHandlerUnseekable(IRuby runtime, InputStream inStream, OutputStream outStream) throws IOException {
        super(runtime);
        String mode = "";
        if (inStream != null) {
            this.input = inStream instanceof BufferedInputStream ? inStream : new BufferedInputStream(inStream);
            mode = mode + "r";
            this.isOpen = true;
        }
        if (outStream != null) {
            this.output = outStream;
            mode = mode + "w";
            this.isOpen = true;
        }
        if ("rw".equals(mode)) {
            this.modes = new IOModes(runtime, 2L);
            this.isOpen = true;
        } else {
            if (!this.isOpen) {
                throw new IOException("Opening nothing?");
            }
            this.modes = new IOModes(runtime, mode);
        }
        this.fileno = RubyIO.getNewFileno();
    }

    public IOHandlerUnseekable(IRuby runtime, int fileno) throws IOException {
        super(runtime);
        switch (fileno) {
            case 0: {
                this.input = new RubyInputStream(runtime.getIn());
                this.modes = new IOModes(runtime, "r");
                this.isOpen = true;
                break;
            }
            case 1: {
                this.output = runtime.getOut();
                this.modes = new IOModes(runtime, "w");
                this.isOpen = true;
                break;
            }
            case 2: {
                this.output = runtime.getErr();
                this.modes = new IOModes(runtime, "w");
                this.isOpen = true;
                break;
            }
            default: {
                throw new IOException("Bad file descriptor");
            }
        }
        this.fileno = fileno;
    }

    public IOHandlerUnseekable(IRuby runtime, int fileno, String mode) throws IOException {
        super(runtime);
        this.modes = new IOModes(runtime, mode);
        if (fileno < 0 || fileno > 2) {
            throw new IOException("Bad file descriptor");
        }
        if (this.modes.isReadable()) {
            this.input = new RubyInputStream(System.in);
            this.isOpen = true;
            if (this.modes.isWriteable()) {
                this.output = System.out;
            }
        } else if (this.isWriteable()) {
            this.output = System.out;
            this.isOpen = true;
        }
        this.fileno = fileno;
    }

    public IOHandler cloneIOHandler() throws IOException {
        return new IOHandlerUnseekable(this.getRuntime(), this.input, this.output);
    }

    public void close() throws IOException, IOHandler.BadDescriptorException {
        if (!this.isOpen()) {
            throw new IOHandler.BadDescriptorException();
        }
        this.isOpen = false;
        if (this.modes.isReadable() && this.input != System.in) {
            this.input.close();
        }
        if (this.modes.isWriteable() && this.output != System.out && this.output != System.err) {
            this.output.close();
        }
    }

    public void flush() throws IOException, IOHandler.BadDescriptorException {
        this.checkWriteable();
        this.output.flush();
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public boolean isEOF() throws IOException, IOHandler.BadDescriptorException {
        this.checkReadable();
        int c = this.input.read();
        if (c == -1) {
            return true;
        }
        this.ungetc(c);
        return false;
    }

    public int pid() {
        return -1;
    }

    public long pos() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void resetByModes(IOModes newModes) {
    }

    public void rewind() throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void seek(long offset, int type) throws IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public void sync() throws IOException {
        this.output.flush();
        if (this.output instanceof FileOutputStream) {
            ((FileOutputStream)this.output).getFD().sync();
        }
    }

    public int sysread() throws IOException {
        return this.input.read();
    }

    public int syswrite(String buf) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        this.output.write(buf.getBytes("ISO8859_1"));
        if (this.isSync) {
            this.sync();
        }
        return buf.length();
    }

    public int syswrite(int c) throws IOException, IOHandler.BadDescriptorException {
        this.getRuntime().secure(4);
        this.checkWriteable();
        this.output.write(c);
        if (this.isSync) {
            this.sync();
        }
        return c;
    }

    public void truncate(long newLength) throws IOException, IOHandler.PipeException {
        throw new IOHandler.PipeException();
    }

    public FileChannel getFileChannel() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"No file channel for unseekable IO");
        }
        return null;
    }

    static {
        $assertionsDisabled = !IOHandlerUnseekable.class.desiredAssertionStatus();
    }
}

