/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyMatchData;
import org.jruby.RubyNumeric;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Split {
    private boolean isWhitespace = false;
    private IRuby runtime;
    private int limit = 0;
    private RubyRegexp pattern;
    private String splitee;
    private List result = new ArrayList();

    public Split(IRuby runtime, String splitee, IRubyObject[] args) {
        if (args.length > 2) {
            throw runtime.newArgumentError(args.length, 2);
        }
        this.splitee = splitee;
        this.runtime = runtime;
        this.pattern = this.getPattern(args);
        this.limit = Split.getLimit(args);
    }

    public RubyArray results() {
        this.process();
        RubyArray resultArray = this.runtime.newArray(this.result.size());
        Iterator iter = this.result.iterator();
        while (iter.hasNext()) {
            resultArray.append(this.runtime.newString((String)iter.next()));
        }
        return resultArray;
    }

    private void process() {
        if (this.limit == 1) {
            this.result.add(this.splitee);
            return;
        }
        int last = 0;
        int beg = 0;
        int hits = 0;
        int len = this.splitee.length();
        ThreadContext context = this.runtime.getCurrentContext();
        while ((beg = this.pattern.searchAgain(this.splitee)) > -1) {
            ++hits;
            RubyMatchData matchData = (RubyMatchData)context.getBackref();
            int end = matchData.matchEndPosition();
            if (beg == 0 && beg == end) continue;
            if (beg != 0 || !this.isWhitespace) {
                this.addResult(Split.substring(this.splitee, last, beg == last && end == beg ? 1 : beg - last));
                long extraPatterns = matchData.getSize();
                int i = 1;
                while ((long)i < extraPatterns) {
                    IRubyObject matchValue = matchData.group(i);
                    if (!matchValue.isNil()) {
                        this.addResult(((RubyString)matchValue).toString());
                    }
                    ++i;
                }
            }
            last = end;
            if (hits + 1 != this.limit) continue;
            break;
        }
        if (hits == 0) {
            this.addResult(this.splitee);
        } else if (last <= len) {
            this.addResult(Split.substring(this.splitee, last, len - last));
        }
        if (this.limit == 0 && this.result.size() > 0) {
            for (int size = this.result.size() - 1; size >= 0 && ((String)this.result.get(size)).length() == 0; --size) {
                this.result.remove(size);
            }
        }
    }

    private static int getLimit(IRubyObject[] args) {
        if (args.length == 2) {
            return RubyNumeric.fix2int(args[1]);
        }
        return 0;
    }

    private RubyRegexp getPattern(IRubyObject[] args) {
        if (args.length == 0) {
            this.isWhitespace = true;
            return RubyRegexp.newRegexp(this.runtime, "\\s+", 0, null);
        }
        if (args[0] instanceof RubyRegexp) {
            return RubyRegexp.regexpValue(args[0]);
        }
        String stringPattern = RubyString.stringValue(args[0]).toString();
        if (stringPattern.equals(" ")) {
            this.isWhitespace = true;
            return RubyRegexp.newRegexp(this.runtime, "\\s+", 0, null);
        }
        return RubyRegexp.newRegexp(this.runtime, Split.unescapeString(stringPattern), 0, null);
    }

    private static String unescapeString(String unescapedString) {
        int length = unescapedString.length();
        char[] charsToEscape = new char[]{'|', '(', ')', '.', '*', '[', ']', '^', '$', '\\', '?'};
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = unescapedString.charAt(i);
            for (int j = 0; j < charsToEscape.length; ++j) {
                if (c != charsToEscape[j]) continue;
                buf.append('\\');
                break;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private void addResult(String string) {
        if (string == null) {
            return;
        }
        this.result.add(string);
    }

    private static String substring(String string, int start, int length) {
        int stringLength = string.length();
        if (length < 0 || start > stringLength) {
            return null;
        }
        if (start < 0 && (start += stringLength) < 0) {
            return null;
        }
        int end = Math.min(stringLength, start + length);
        return string.substring(start, end);
    }
}

