/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import org.jruby.IRuby;
import org.jruby.runtime.builtin.IRubyObject;

public class ZlibDeflate {
    private Deflater flater;
    private StringBuffer collected;
    private IRuby runtime;
    public static final int DEF_MEM_LEVEL = 8;
    public static final int MAX_MEM_LEVEL = 9;
    public static final int MAX_WBITS = 15;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;
    public static final int FINISH = 4;

    public ZlibDeflate(IRubyObject caller, int level, int win_bits, int memlevel, int strategy) {
        this.flater = new Deflater(level, false);
        this.flater.setStrategy(strategy);
        this.collected = new StringBuffer();
        this.runtime = caller.getRuntime();
    }

    public static IRubyObject s_deflate(IRubyObject caller, String str, int level) throws UnsupportedEncodingException, DataFormatException, IOException {
        ZlibDeflate zstream = new ZlibDeflate(caller, level, 15, 8, 0);
        IRubyObject result = zstream.deflate(str, 4);
        zstream.close();
        return result;
    }

    public Deflater getDeflater() {
        return this.flater;
    }

    public void append(IRubyObject obj) throws IOException, UnsupportedEncodingException {
        this.append(obj.convertToString().toString());
    }

    public void append(String obj) throws IOException, UnsupportedEncodingException {
        this.collected.append(obj);
    }

    public void params(int level, int strategy) {
        this.flater.setLevel(level);
        this.flater.setStrategy(strategy);
    }

    public IRubyObject set_dictionary(IRubyObject str) throws UnsupportedEncodingException {
        this.flater.setDictionary(str.convertToString().toString().getBytes("ISO8859_1"));
        return str;
    }

    public IRubyObject flush(int flush) throws IOException {
        return this.deflate("", flush);
    }

    public IRubyObject deflate(String str, int flush) throws IOException {
        if (null == str) {
            StringBuffer result = new StringBuffer();
            byte[] outp = new byte[1024];
            byte[] buf = this.collected.toString().getBytes("ISO8859_1");
            this.collected = new StringBuffer();
            this.flater.setInput(buf);
            this.flater.finish();
            int resultLength = -1;
            while (!this.flater.finished() && resultLength != 0) {
                resultLength = this.flater.deflate(outp);
                result.append(new String(outp, 0, resultLength, "ISO-8859-1"));
            }
            return this.runtime.newString(result.toString());
        }
        this.append(str);
        if (flush == 4) {
            StringBuffer result = new StringBuffer();
            byte[] outp = new byte[1024];
            byte[] buf = this.collected.toString().getBytes("ISO8859_1");
            this.collected = new StringBuffer();
            this.flater.setInput(buf);
            this.flater.finish();
            int resultLength = -1;
            while (!this.flater.finished() && resultLength != 0) {
                resultLength = this.flater.deflate(outp);
                result.append(new String(outp, 0, resultLength, "ISO-8859-1"));
            }
            return this.runtime.newString(result.toString());
        }
        return this.runtime.newString("");
    }

    public IRubyObject finish() throws Exception {
        StringBuffer result = new StringBuffer();
        byte[] outp = new byte[1024];
        byte[] buf = this.collected.toString().getBytes("ISO8859_1");
        this.collected = new StringBuffer();
        this.flater.setInput(buf);
        this.flater.finish();
        int resultLength = -1;
        while (!this.flater.finished() && resultLength != 0) {
            resultLength = this.flater.deflate(outp);
            result.append(new String(outp, 0, resultLength, "ISO-8859-1"));
        }
        return this.runtime.newString(result.toString());
    }

    public void close() {
    }
}

