/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jvyaml.Resolver;
import org.jvyaml.ResolverException;
import org.jvyaml.nodes.MappingNode;
import org.jvyaml.nodes.Node;
import org.jvyaml.nodes.ScalarNode;
import org.jvyaml.nodes.SequenceNode;

public class ResolverImpl
implements Resolver {
    private static final Map yamlImplicitResolvers = new HashMap();
    private static final Map yamlPathResolvers = new HashMap();
    private List resolverExactPaths = new LinkedList();
    private List resolverPrefixPaths = new LinkedList();

    public static void addImplicitResolver(String tag, Pattern regexp, String first) {
        String firstVal = first;
        if (firstVal == null || "".equals("firstVal")) {
            LinkedList<Object[]> curr = (LinkedList<Object[]>)yamlImplicitResolvers.get("");
            if (curr == null) {
                curr = new LinkedList<Object[]>();
                yamlImplicitResolvers.put("", curr);
            }
            curr.add(new Object[]{tag, regexp});
        } else {
            char[] chrs = firstVal.toCharArray();
            int j = chrs.length;
            for (int i = 0; i < j; ++i) {
                Character theC = new Character(chrs[i]);
                LinkedList<Object[]> curr = (LinkedList<Object[]>)yamlImplicitResolvers.get(theC);
                if (curr == null) {
                    curr = new LinkedList<Object[]>();
                    yamlImplicitResolvers.put(theC, curr);
                }
                curr.add(new Object[]{tag, regexp});
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addPathResolver(String tag, List path, Class kind) {
        LinkedList<Object[]> newPath = new LinkedList<Object[]>();
        Object var4_4 = null;
        Boolean indexCheck = null;
        Iterator iter = path.iterator();
        while (iter.hasNext()) {
            void var4_14;
            void var4_10;
            Object element = iter.next();
            if (element instanceof List) {
                List eList = (List)element;
                if (eList.size() == 2) {
                    Object e = eList.get(0);
                    indexCheck = (Boolean)eList.get(1);
                } else {
                    if (eList.size() != 1) throw new ResolverException("Invalid path element: " + element);
                    Object e = eList.get(0);
                    indexCheck = Boolean.TRUE;
                }
            } else {
                Object var4_9 = null;
                indexCheck = (Boolean)element;
            }
            if (var4_10 instanceof String) {
                Class clazz = class$org$jvyaml$nodes$ScalarNode == null ? ResolverImpl.class$("org.jvyaml.nodes.ScalarNode") : class$org$jvyaml$nodes$ScalarNode;
            } else if (var4_10 instanceof List) {
                Class clazz = class$org$jvyaml$nodes$SequenceNode == null ? ResolverImpl.class$("org.jvyaml.nodes.SequenceNode") : class$org$jvyaml$nodes$SequenceNode;
            } else if (var4_10 instanceof Map) {
                Class clazz = class$org$jvyaml$nodes$MappingNode == null ? ResolverImpl.class$("org.jvyaml.nodes.MappingNode") : class$org$jvyaml$nodes$MappingNode;
            } else if (!(null == var4_10 || (class$org$jvyaml$nodes$ScalarNode == null ? ResolverImpl.class$("org.jvyaml.nodes.ScalarNode") : class$org$jvyaml$nodes$ScalarNode).equals(var4_10) || (class$org$jvyaml$nodes$SequenceNode == null ? ResolverImpl.class$("org.jvyaml.nodes.SequenceNode") : class$org$jvyaml$nodes$SequenceNode).equals(var4_10) || (class$org$jvyaml$nodes$MappingNode == null ? ResolverImpl.class$("org.jvyaml.nodes.MappingNode") : class$org$jvyaml$nodes$MappingNode).equals(var4_10))) {
                throw new ResolverException("Invalid node checker: " + var4_10);
            }
            if (!(indexCheck instanceof String) && !(indexCheck instanceof Integer) && null != indexCheck) {
                throw new ResolverException("Invalid index checker: " + indexCheck);
            }
            newPath.add(new Object[]{var4_14, indexCheck});
        }
        Class newKind = null;
        if (String.class.equals(kind)) {
            newKind = ScalarNode.class;
        } else if (List.class.equals(kind)) {
            newKind = SequenceNode.class;
        } else if (Map.class.equals(kind)) {
            newKind = MappingNode.class;
        } else {
            if (!(kind == null || ScalarNode.class.equals(kind) || SequenceNode.class.equals(kind) || MappingNode.class.equals(kind))) {
                throw new ResolverException("Invalid node kind: " + kind);
            }
            newKind = kind;
        }
        ArrayList<LinkedList<Object[]>> x = new ArrayList<LinkedList<Object[]>>(1);
        x.add(newPath);
        ArrayList<Serializable> y = new ArrayList<Serializable>(2);
        y.add(x);
        y.add(kind);
        yamlPathResolvers.put(y, tag);
    }

    public void descendResolver(Node currentNode, Object currentIndex) {
        HashMap exactPaths = new HashMap();
        LinkedList<Object> prefixPaths = new LinkedList<Object>();
        if (null != currentNode) {
            int depth = this.resolverPrefixPaths.size();
            Iterator iter = ((List)this.resolverPrefixPaths.get(0)).iterator();
            while (iter.hasNext()) {
                Object[] obj = (Object[])iter.next();
                List path = (List)obj[0];
                if (!this.checkResolverPrefix(depth, path, (Class)obj[1], currentNode, currentIndex)) continue;
                if (path.size() > depth) {
                    prefixPaths.add(new Object[]{path, obj[1]});
                    continue;
                }
                ArrayList<Object> resPath = new ArrayList<Object>(2);
                resPath.add(path);
                resPath.add(obj[1]);
                exactPaths.put(obj[1], yamlPathResolvers.get(resPath));
            }
        } else {
            Iterator iter = yamlPathResolvers.keySet().iterator();
            while (iter.hasNext()) {
                List key = (List)iter.next();
                List path = (List)key.get(0);
                Class kind = (Class)key.get(1);
                if (null == path) {
                    exactPaths.put(kind, yamlPathResolvers.get(key));
                    continue;
                }
                prefixPaths.add(key);
            }
        }
        this.resolverExactPaths.add(0, exactPaths);
        this.resolverPrefixPaths.add(0, prefixPaths);
    }

    public void ascendResolver() {
        this.resolverExactPaths.remove(0);
        this.resolverPrefixPaths.remove(0);
    }

    public boolean checkResolverPrefix(int depth, List path, Class kind, Node currentNode, Object currentIndex) {
        Object[] check = (Object[])path.get(depth - 1);
        Object nodeCheck = check[0];
        Object indexCheck = check[1];
        if (nodeCheck instanceof String ? !currentNode.getTag().equals(nodeCheck) : null != nodeCheck && !((Class)nodeCheck).isInstance(currentNode)) {
            return false;
        }
        if (indexCheck == Boolean.TRUE && currentIndex != null) {
            return false;
        }
        if (indexCheck == Boolean.FALSE && currentIndex == null) {
            return false;
        }
        return !(indexCheck instanceof String ? !(currentIndex instanceof ScalarNode) || !indexCheck.equals(((ScalarNode)currentIndex).getValue()) : indexCheck instanceof Integer && !currentIndex.equals(indexCheck));
    }

    public String resolve(Class kind, String value, boolean[] implicit) {
        Map exactPaths;
        List resolvers = null;
        if (kind.equals(ScalarNode.class) && implicit[0]) {
            resolvers = "".equals(value) ? (LinkedList)yamlImplicitResolvers.get("") : (List)yamlImplicitResolvers.get(new Character(value.charAt(0)));
            if (resolvers == null) {
                resolvers = new LinkedList();
            }
            if (yamlImplicitResolvers.containsKey(null)) {
                resolvers.addAll((List)yamlImplicitResolvers.get(null));
            }
            Iterator iter = resolvers.iterator();
            while (iter.hasNext()) {
                Object[] val = (Object[])iter.next();
                if (!((Pattern)val[1]).matcher(value).matches()) continue;
                return (String)val[0];
            }
        }
        if ((exactPaths = (Map)this.resolverExactPaths.get(0)).containsKey(kind)) {
            return (String)exactPaths.get(kind);
        }
        if (exactPaths.containsKey(null)) {
            return (String)exactPaths.get(null);
        }
        if (kind.equals(ScalarNode.class)) {
            return "tag:yaml.org,2002:str";
        }
        if (kind.equals(SequenceNode.class)) {
            return "tag:yaml.org,2002:seq";
        }
        if (kind.equals(MappingNode.class)) {
            return "tag:yaml.org,2002:map";
        }
        return null;
    }

    static {
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:bool", Pattern.compile("^(?:yes|Yes|YES|no|No|NO|true|True|TRUE|false|False|FALSE|on|On|ON|off|Off|OFF)$"), "yYnNtTfFoO");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:float", Pattern.compile("^(?:[-+]?(?:[0-9][0-9_]*)\\.[0-9_]*(?:[eE][-+][0-9]+)?|[-+]?(?:[0-9][0-9_]*)?\\.[0-9_]+(?:[eE][-+][0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$"), "-+0123456789.");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:int", Pattern.compile("^(?:[-+]?0b[0-1_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*(?::[0-5]?[0-9])+)$"), "-+0123456789");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:merge", Pattern.compile("^(?:<<)$"), "<");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:null", Pattern.compile("^(?:~|null|Null|NULL| )$"), "~nN\u0000");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:null", Pattern.compile("^$"), null);
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:timestamp#ymd", Pattern.compile("^(?:[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]|[0-9][0-9][0-9][0-9]-[0-9][0-9]?-[x0-9][0-9]?)$"), "0123456789");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:timestamp", Pattern.compile("^(?:[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]|[0-9][0-9][0-9][0-9]-[0-9][0-9]?-[0-9][0-9]?(?:[Tt]|[ \t]+)[0-9][0-9]?:[0-9][0-9]:[0-9][0-9](?:\\.[0-9]*)?(?:[ \t]*(?:Z|[-+][0-9][0-9]?(?::[0-9][0-9])?))?)$"), "0123456789");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:value", Pattern.compile("^(?:=)$"), "=");
        ResolverImpl.addImplicitResolver("tag:yaml.org,2002:yaml", Pattern.compile("^(?:!|&|\\*)$"), "!&*");
    }
}

