/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.aop.dynaop;

import dynaop.Aspects;
import dynaop.Interceptor;
import dynaop.InterceptorFactory;
import dynaop.MixinFactory;
import dynaop.ProxyFactory;
import dynaop.util.Classes;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.nanocontainer.aop.AspectsManager;
import org.nanocontainer.aop.ClassPointcut;
import org.nanocontainer.aop.ComponentPointcut;
import org.nanocontainer.aop.MethodPointcut;
import org.nanocontainer.aop.PointcutsFactory;
import org.nanocontainer.aop.dynaop.ComponentAspectsCollection;
import org.nanocontainer.aop.dynaop.ContainerLoader;
import org.nanocontainer.aop.dynaop.ContainerSuppliedInterceptorFactory;
import org.nanocontainer.aop.dynaop.ContainerSuppliedMixinFactory;
import org.nanocontainer.aop.dynaop.DynaopPointcutsFactory;
import org.nanocontainer.aop.dynaop.InterceptorComponentAspect;
import org.nanocontainer.aop.dynaop.InterfacesComponentAspect;
import org.nanocontainer.aop.dynaop.MethodInterceptorAdapter;
import org.nanocontainer.aop.dynaop.MixinComponentAspect;
import org.nanocontainer.aop.dynaop.PicoContainerProxy;
import org.picocontainer.PicoContainer;

public class DynaopAspectsManager
implements AspectsManager {
    private final Aspects containerAspects;
    private final PointcutsFactory pointcutsFactory;
    private final ContainerLoader containerLoader = new ContainerLoader();
    private final PicoContainer container = PicoContainerProxy.create(this.containerLoader);
    private final ComponentAspectsCollection componentAspects = new ComponentAspectsCollection();

    public DynaopAspectsManager(Aspects containerAspects, PointcutsFactory pointcutsFactory) {
        this.containerAspects = containerAspects;
        this.pointcutsFactory = pointcutsFactory;
    }

    public DynaopAspectsManager(Aspects containerAspects) {
        this(containerAspects, new DynaopPointcutsFactory());
    }

    public DynaopAspectsManager(PointcutsFactory pointcutsFactory) {
        this(new Aspects(), pointcutsFactory);
    }

    public DynaopAspectsManager() {
        this(new Aspects());
    }

    public void registerInterceptor(ClassPointcut classPointcut, MethodPointcut methodPointcut, Object interceptorComponentKey) {
        this.containerAspects.interceptor(this.getClassPointcut(classPointcut), this.getMethodPointcut(methodPointcut), this.createInterceptorFactory(interceptorComponentKey));
    }

    public void registerInterceptor(ClassPointcut classPointcut, MethodPointcut methodPointcut, MethodInterceptor interceptor) {
        this.containerAspects.interceptor(this.getClassPointcut(classPointcut), this.getMethodPointcut(methodPointcut), this.createInterceptor(interceptor));
    }

    public void registerInterceptor(ComponentPointcut componentPointcut, MethodPointcut methodPointcut, Object interceptorComponentKey) {
        this.componentAspects.add(new InterceptorComponentAspect(componentPointcut, this.getMethodPointcut(methodPointcut), this.createInterceptorFactory(interceptorComponentKey)));
    }

    public void registerInterceptor(ComponentPointcut componentPointcut, MethodPointcut methodPointcut, MethodInterceptor interceptor) {
        this.componentAspects.add(new InterceptorComponentAspect(componentPointcut, this.getMethodPointcut(methodPointcut), this.createInterceptor(interceptor)));
    }

    public void registerMixin(ClassPointcut classPointcut, Class mixinClass) {
        this.registerMixin(classPointcut, Classes.getAllInterfaces((Class)mixinClass), mixinClass);
    }

    public void registerMixin(ClassPointcut classPointcut, Class[] interfaces, Class mixinClass) {
        this.containerAspects.mixin(this.getClassPointcut(classPointcut), interfaces, (MixinFactory)new ContainerSuppliedMixinFactory(this.container, mixinClass));
    }

    public void registerMixin(ComponentPointcut componentPointcut, Class mixinClass) {
        this.registerMixin(componentPointcut, Classes.getAllInterfaces((Class)mixinClass), mixinClass);
    }

    public void registerMixin(ComponentPointcut componentPointcut, Class[] interfaces, Class mixinClass) {
        this.componentAspects.add(new MixinComponentAspect(componentPointcut, interfaces, new ContainerSuppliedMixinFactory(this.container, mixinClass)));
    }

    public void registerInterfaces(ClassPointcut classPointcut, Class[] interfaces) {
        this.containerAspects.interfaces(this.getClassPointcut(classPointcut), interfaces);
    }

    public void registerInterfaces(ComponentPointcut componentPointcut, Class[] interfaces) {
        this.componentAspects.add(new InterfacesComponentAspect(componentPointcut, interfaces));
    }

    public PointcutsFactory getPointcutsFactory() {
        return this.pointcutsFactory;
    }

    public Object applyAspects(Object componentKey, Object component, PicoContainer container) {
        this.containerLoader.setContainer(container);
        Aspects aspects = this.componentAspects.registerAspects(componentKey, this.containerAspects);
        return ProxyFactory.getInstance((Aspects)aspects).wrap(component);
    }

    private dynaop.ClassPointcut getClassPointcut(final ClassPointcut classPointcut) {
        if (classPointcut instanceof dynaop.ClassPointcut) {
            return (dynaop.ClassPointcut)classPointcut;
        }
        return new dynaop.ClassPointcut(){

            public boolean picks(Class clazz) {
                return classPointcut.picks(clazz);
            }
        };
    }

    private dynaop.MethodPointcut getMethodPointcut(final MethodPointcut methodPointcut) {
        if (methodPointcut instanceof dynaop.MethodPointcut) {
            return (dynaop.MethodPointcut)methodPointcut;
        }
        return new dynaop.MethodPointcut(){

            public boolean picks(Method method) {
                return methodPointcut.picks(method);
            }
        };
    }

    private Interceptor createInterceptor(MethodInterceptor methodInterceptor) {
        return new MethodInterceptorAdapter(methodInterceptor);
    }

    private InterceptorFactory createInterceptorFactory(Object interceptorComponent) {
        return new ContainerSuppliedInterceptorFactory(this.container, interceptorComponent);
    }
}

