/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.webcontainer;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.nanocontainer.webcontainer.PicoFilterHolder;
import org.nanocontainer.webcontainer.PicoServletHandler;
import org.nanocontainer.webcontainer.PicoServletHolder;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class PicoContextHandler {
    private final ContextHandler context;
    private final Server server;
    private final PicoContainer parentContainer;
    private final boolean withSessionHandler;
    private PicoServletHandler servletHandler;
    public static final int DEFAULT = 0;
    public static final int REQUEST = 1;
    public static final int FORWARD = 2;
    public static final int INCLUDE = 4;
    public static final int ERROR = 8;
    public static final int ALL = 15;

    public PicoContextHandler(ContextHandler context, Server server, PicoContainer parentContainer, boolean sessionManager) {
        this.context = context;
        this.server = server;
        this.parentContainer = parentContainer;
        this.withSessionHandler = sessionManager;
    }

    public PicoServletHolder addServletWithMapping(Class servletClass, String pathMapping) {
        PicoServletHandler handler = this.getServletHandler();
        return (PicoServletHolder)handler.addServletWithMapping(servletClass, pathMapping);
    }

    public Servlet addServletWithMapping(Servlet servlet, String pathMapping) {
        PicoServletHandler handler = this.getServletHandler();
        handler.addServletWithMapping(new ServletHolder(servlet), pathMapping);
        return servlet;
    }

    private synchronized PicoServletHandler getServletHandler() {
        if (this.servletHandler == null) {
            this.servletHandler = new PicoServletHandler(this.parentContainer);
            this.servletHandler.setServer(this.server);
            if (this.withSessionHandler) {
                SessionHandler sessionHandler = new SessionHandler();
                sessionHandler.setServer(this.server);
                this.context.addHandler((Handler)sessionHandler);
                sessionHandler.addHandler((Handler)this.servletHandler);
            } else {
                this.context.addHandler((Handler)this.servletHandler);
            }
        }
        return this.servletHandler;
    }

    public PicoFilterHolder addFilterWithMapping(Class filterClass, String pathMapping, int dispatchers) {
        PicoServletHandler handler = this.getServletHandler();
        return (PicoFilterHolder)handler.addFilterWithMapping(filterClass, pathMapping, dispatchers);
    }

    public Filter addFilterWithMapping(Filter filter, String pathMapping, int dispatchers) {
        PicoServletHandler servletHandler = this.getServletHandler();
        servletHandler.addFilterWithMapping(new FilterHolder(filter), pathMapping, dispatchers);
        return filter;
    }

    public EventListener addListener(Class listenerClass) {
        DefaultPicoContainer child = new DefaultPicoContainer(this.parentContainer);
        child.registerComponentImplementation((Object)EventListener.class, listenerClass);
        EventListener instance = (EventListener)child.getComponentInstance((Object)EventListener.class);
        return this.addListener(instance);
    }

    public EventListener addListener(EventListener listener) {
        this.context.addEventListener(listener);
        return listener;
    }

    public void setStaticContext(String absolutePath) {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(absolutePath);
        this.context.addHandler((Handler)resourceHandler);
    }

    public void setStaticContext(String absolutePath, String welcomePage) {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(absolutePath);
        resourceHandler.setWelcomeFiles(new String[]{welcomePage});
        this.context.addHandler((Handler)resourceHandler);
    }

    public void setDefaultHandling(String absolutePath, String scratchDir, String pageSuffix) {
        this.context.setResourceBase(absolutePath);
        PicoServletHandler handler = this.getServletHandler();
        PicoServletHolder jspHolder = new PicoServletHolder(this.parentContainer);
        jspHolder.setName("jsp");
        jspHolder.setClassName("org.apache.jasper.servlet.JspServlet");
        jspHolder.setInitParameter("scratchdir", scratchDir);
        jspHolder.setInitParameter("logVerbosityLevel", "DEBUG");
        jspHolder.setInitParameter("fork", "false");
        jspHolder.setInitParameter("xpoweredBy", "false");
        jspHolder.setForcedPath(null);
        jspHolder.setInitOrder(0);
        handler.addServletWithMapping(jspHolder, pageSuffix);
        handler.addServletWithMapping(DefaultServlet.class.getName(), "/");
    }

    public void addErrorHandler() {
        this.addErrorHandler((ErrorHandler)new ErrorPageErrorHandler());
    }

    public void addErrorHandler(ErrorHandler handler) {
        this.context.setErrorHandler(handler);
    }
}

