/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.nanowar.jsf;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.picocontainer.PicoContainer;

public class NanoWarDelegatingVariableResolver
extends VariableResolver {
    private VariableResolver nested;

    public NanoWarDelegatingVariableResolver(VariableResolver decorated) {
        if (decorated == null) {
            throw new NullPointerException("decorated");
        }
        this.nested = decorated;
    }

    protected VariableResolver getNested() {
        return this.nested;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        PicoContainer nano = this.getPicoContainer(facesContext);
        Object result = nano.getComponentInstance((Object)name);
        if (result == null) {
            return this.nested.resolveVariable(facesContext, name);
        }
        return result;
    }

    protected PicoContainer getPicoContainer(FacesContext facesContext) throws EvaluationException {
        Map requestAttributeMap = facesContext.getExternalContext().getRequestMap();
        PicoContainer container = null;
        if (requestAttributeMap != null) {
            container = (PicoContainer)requestAttributeMap.get("nanocontainer.request");
        }
        if (requestAttributeMap == null || container == null) {
            Map sessionMap = facesContext.getExternalContext().getSessionMap();
            if (sessionMap != null) {
                container = (PicoContainer)sessionMap.get("nanocontainer.session");
            }
            if ((sessionMap == null || container == null) && (container = (PicoContainer)facesContext.getExternalContext().getApplicationMap().get("nanocontainer.application")) == null) {
                throw new EvaluationException("The NanoWar delegating variable resolver is installed, however no NanoWar container was found in the request or application scope.");
            }
        }
        return container;
    }
}

