/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.nanocontainer.persistence.ExceptionHandler;

public abstract class AbstractConnection
implements Connection {
    private ExceptionHandler jdbcExceptionHandler;

    protected AbstractConnection(ExceptionHandler jdbcExceptionHandler) {
        this.jdbcExceptionHandler = jdbcExceptionHandler;
    }

    protected AbstractConnection() {
        this.jdbcExceptionHandler = null;
    }

    protected abstract Connection getDelegatedConnection() throws SQLException;

    protected abstract void invalidateDelegatedConnection();

    protected SQLException handleException(Exception cause) throws RuntimeException {
        try {
            this.invalidateDelegatedConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.jdbcExceptionHandler == null) {
            if (cause instanceof SQLException) {
                return (SQLException)cause;
            }
            throw (RuntimeException)cause;
        }
        throw this.jdbcExceptionHandler.handle(cause);
    }

    public Statement createStatement() throws SQLException {
        try {
            return this.getDelegatedConnection().createStatement();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareStatement(sql);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareCall(sql);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.getDelegatedConnection().nativeSQL(sql);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.getDelegatedConnection().setAutoCommit(autoCommit);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getDelegatedConnection().getAutoCommit();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void commit() throws SQLException {
        try {
            this.getDelegatedConnection().commit();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void rollback() throws SQLException {
        try {
            this.getDelegatedConnection().rollback();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void close() throws SQLException {
        try {
            this.getDelegatedConnection().close();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            return this.getDelegatedConnection().isClosed();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getDelegatedConnection().getMetaData();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.getDelegatedConnection().setReadOnly(readOnly);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.getDelegatedConnection().isReadOnly();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this.getDelegatedConnection().setCatalog(catalog);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.getDelegatedConnection().getCatalog();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.getDelegatedConnection().setTransactionIsolation(level);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getDelegatedConnection().getTransactionIsolation();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getDelegatedConnection().getWarnings();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.getDelegatedConnection().clearWarnings();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.getDelegatedConnection().createStatement(resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.getDelegatedConnection().getTypeMap();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.getDelegatedConnection().setTypeMap(map);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            this.getDelegatedConnection().setHoldability(holdability);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public int getHoldability() throws SQLException {
        try {
            return this.getDelegatedConnection().getHoldability();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.getDelegatedConnection().setSavepoint();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this.getDelegatedConnection().setSavepoint(name);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.getDelegatedConnection().rollback(savepoint);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getDelegatedConnection().releaseSavepoint(savepoint);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.getDelegatedConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareStatement(sql, autoGeneratedKeys);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareStatement(sql, columnIndexes);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.getDelegatedConnection().prepareStatement(sql, columnNames);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }
}

