/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.webcontainer.groovy;

import groovy.util.NodeBuilder;
import java.util.Map;
import org.nanocontainer.webcontainer.PicoContext;
import org.nanocontainer.webcontainer.PicoJettyServer;
import org.nanocontainer.webcontainer.PicoWebAppContext;
import org.nanocontainer.webcontainer.groovy.ContextBuilder;
import org.nanocontainer.webcontainer.groovy.WarFileBuilder;
import org.picocontainer.MutablePicoContainer;

public class ServerBuilder
extends NodeBuilder {
    private final PicoJettyServer server;
    private final MutablePicoContainer parentContainer;

    public ServerBuilder(PicoJettyServer server, MutablePicoContainer parentContainer) {
        this.server = server;
        this.parentContainer = parentContainer;
    }

    protected Object createNode(Object name, Map map) {
        if (name.equals("context")) {
            return this.createContext(map);
        }
        if (name.equals("blockingChannelConnector")) {
            return this.createBlockingChannelConnector(map);
        }
        if (name.equals("xmlWebApplication")) {
            return this.createXmlWebApplication(map);
        }
        return null;
    }

    protected Object createBlockingChannelConnector(Map map) {
        int port = (Integer)map.remove("port");
        return this.server.createBlockingChannelConnector((String)map.remove("host"), port);
    }

    protected Object createContext(Map map) {
        boolean sessions = false;
        if (map.containsKey("sessions")) {
            sessions = Boolean.valueOf((String)map.remove("sessions"));
        }
        PicoContext context = this.server.createContext((String)map.remove("path"), sessions);
        return new ContextBuilder(this.parentContainer, context);
    }

    protected Object createXmlWebApplication(Map map) {
        PicoWebAppContext context = this.server.addWebApplication((String)map.remove("path"), (String)map.remove("warfile"));
        return new WarFileBuilder(this.parentContainer, context);
    }
}

