/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.webcontainer;

import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.nanocontainer.webcontainer.PicoFilterHolder;
import org.nanocontainer.webcontainer.PicoServletHolder;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class PicoContext {
    private final Context context;
    private final PicoContainer parentContainer;
    private final boolean withSessionHandler;
    public static final int DEFAULT = 0;
    public static final int REQUEST = 1;
    public static final int FORWARD = 2;
    public static final int INCLUDE = 4;
    public static final int ERROR = 8;
    public static final int ALL = 15;

    public PicoContext(Context context, PicoContainer parentContainer, boolean withSessionHandler) {
        this.context = context;
        this.parentContainer = parentContainer;
        this.withSessionHandler = withSessionHandler;
    }

    public PicoServletHolder addServletWithMapping(Class servletClass, String pathMapping) {
        PicoServletHolder holder = new PicoServletHolder(servletClass, this.parentContainer);
        this.context.addServlet((ServletHolder)holder, pathMapping);
        return holder;
    }

    public Servlet addServletWithMapping(Servlet servlet, String pathMapping) {
        ServletHolder holder = new ServletHolder(servlet);
        this.context.addServlet(holder, pathMapping);
        return servlet;
    }

    public PicoFilterHolder addFilterWithMapping(Class filterClass, String pathMapping, int dispatchers) {
        PicoFilterHolder filterHolder = new PicoFilterHolder(filterClass, this.parentContainer);
        this.context.addFilter((FilterHolder)filterHolder, pathMapping, 0);
        return filterHolder;
    }

    public Filter addFilterWithMapping(Filter filter, String pathMapping, int dispatchers) {
        this.context.addFilter(new FilterHolder(filter), pathMapping, dispatchers);
        return filter;
    }

    public void addInitParam(String param, String value) {
        HashMap<String, String> params = new HashMap<String, String>(this.context.getInitParams());
        params.put(param, value);
        this.context.setInitParams(params);
    }

    public EventListener addListener(Class listenerClass) {
        DefaultPicoContainer child = new DefaultPicoContainer(this.parentContainer);
        child.registerComponentImplementation((Object)EventListener.class, listenerClass);
        EventListener instance = (EventListener)child.getComponentInstance((Object)EventListener.class);
        return this.addListener(instance);
    }

    public EventListener addListener(EventListener listener) {
        this.context.addEventListener(listener);
        return listener;
    }

    public void setStaticContext(String absolutePath) {
        this.context.addServlet(DefaultServlet.class.getName(), "/");
        this.context.setResourceBase(absolutePath);
    }

    public void setStaticContext(String absolutePath, String welcomePage) {
        this.context.addServlet(DefaultServlet.class.getName(), "/");
        this.context.setResourceBase(absolutePath);
        this.context.setWelcomeFiles(new String[]{welcomePage});
    }

    public void setDefaultHandling(String absolutePath, String scratchDir, String pageSuffix) {
        this.context.setResourceBase(absolutePath);
        PicoServletHolder jspHolder = new PicoServletHolder(this.parentContainer);
        jspHolder.setName("jsp");
        jspHolder.setClassName("org.apache.jasper.servlet.JspServlet");
        jspHolder.setInitParameter("scratchdir", scratchDir);
        jspHolder.setInitParameter("logVerbosityLevel", "DEBUG");
        jspHolder.setInitParameter("fork", "false");
        jspHolder.setInitParameter("xpoweredBy", "false");
        jspHolder.setForcedPath(null);
        jspHolder.setInitOrder(0);
        this.context.addServlet((ServletHolder)jspHolder, "*.jsp");
        this.context.addServlet(DefaultServlet.class.getName(), "/");
    }

    public void addErrorHandler() {
        this.addErrorHandler((ErrorHandler)new ErrorPageErrorHandler());
    }

    public void addErrorHandler(ErrorHandler handler) {
        this.context.setErrorHandler(handler);
    }
}

