/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.webcontainer;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.BlockingChannelConnector;
import org.nanocontainer.webcontainer.JettyServerLifecycleException;
import org.nanocontainer.webcontainer.PicoContextHandler;
import org.nanocontainer.webcontainer.PicoWebAppContext;
import org.picocontainer.PicoContainer;
import org.picocontainer.alternatives.EmptyPicoContainer;

public class PicoJettyServer
extends EmptyPicoContainer
implements PicoContainer {
    private final Server server;
    private final PicoContainer parentContainer;
    private ErrorHandler errorHandler;

    public PicoJettyServer(PicoContainer parentContainer) {
        this.parentContainer = parentContainer;
        this.server = new Server();
        this.server.setHandler((Handler)new HandlerList());
    }

    public PicoJettyServer(String host, int port, PicoContainer parentContainer) {
        this(parentContainer);
        this.createBlockingChannelConnector(host, port);
    }

    public Connector createBlockingChannelConnector(String host, int port) {
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setHost(host);
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        return connector;
    }

    public PicoContextHandler createContext(String contextPath, boolean withSessionHandler) {
        ContextHandler context = new ContextHandler();
        context.setContextPath(contextPath);
        this.server.addHandler((Handler)context);
        return new PicoContextHandler(context, this.server, this.parentContainer, withSessionHandler);
    }

    public PicoWebAppContext addWebApplication(String contextPath, String warFile) {
        PicoWebAppContext wah = new PicoWebAppContext(this.parentContainer);
        wah.setContextPath(contextPath);
        wah.setExtractWAR(true);
        wah.setWar(warFile);
        wah.setParentLoaderPriority(true);
        this.server.addHandler((Handler)wah);
        return wah;
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JettyServerLifecycleException("Jetty couldn't start", e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new JettyServerLifecycleException("Jetty couldn't stop", e);
        }
    }

    public void addRequestLog(RequestLog requestLog) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog(requestLog);
        this.server.addHandler((Handler)requestLogHandler);
    }
}

