/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate;

import org.hibernate.StaleObjectStateException;
import org.hibernate.TransactionException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.exception.LockAcquisitionException;
import org.nanocontainer.persistence.ExceptionFactory;
import org.nanocontainer.persistence.ExceptionHandler;

public class DefaultHibernateExceptionHandler
implements ExceptionHandler {
    private ExceptionFactory exceptionFactory;

    public DefaultHibernateExceptionHandler(ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    public RuntimeException handle(Throwable ex) {
        if (ex instanceof StaleObjectStateException) {
            StaleObjectStateException e = (StaleObjectStateException)ex;
            return this.exceptionFactory.createStaleObjectStateException((Throwable)e, e.getEntityName(), e.getIdentifier());
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException e = (LockAcquisitionException)ex;
            return this.exceptionFactory.createConcurrencyFailureException((Throwable)e);
        }
        if (ex instanceof UnresolvableObjectException) {
            UnresolvableObjectException e = (UnresolvableObjectException)ex;
            return this.exceptionFactory.createObjectRetrievalFailureException((Throwable)e, e.getEntityName(), e.getIdentifier());
        }
        if (ex instanceof WrongClassException) {
            WrongClassException e = (WrongClassException)ex;
            return this.exceptionFactory.createObjectRetrievalFailureException((Throwable)e, e.getEntityName(), e.getIdentifier());
        }
        if (ex instanceof TransactionException) {
            return this.exceptionFactory.createTransactionException(ex);
        }
        return this.exceptionFactory.createPersistenceException(ex);
    }
}

