/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate;

import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.nanocontainer.persistence.ExceptionHandler;
import org.nanocontainer.persistence.hibernate.SessionDelegator;

public class FailoverSessionDelegator
extends SessionDelegator {
    private SessionFactory sessionFactory;
    private Session session = null;
    private Interceptor interceptor = null;

    public FailoverSessionDelegator(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public FailoverSessionDelegator(SessionFactory sessionFactory, ExceptionHandler exceptionHandler) {
        super(exceptionHandler);
        this.sessionFactory = sessionFactory;
    }

    public FailoverSessionDelegator(SessionFactory sessionFactory, Interceptor interceptor) {
        this(sessionFactory);
        this.setInterceptor(interceptor);
    }

    public FailoverSessionDelegator(SessionFactory sessionFactory, Interceptor interceptor, ExceptionHandler exceptionHandler) {
        this(sessionFactory, exceptionHandler);
        this.setInterceptor(interceptor);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session getDelegatedSession() {
        if (this.session == null) {
            try {
                this.session = this.interceptor == null ? this.sessionFactory.openSession() : this.sessionFactory.openSession(this.interceptor);
            }
            catch (RuntimeException ex) {
                throw this.handleException(ex);
            }
        }
        return this.session;
    }

    public Connection close() throws HibernateException {
        try {
            Connection connection = this.getDelegatedSession().close();
            return connection;
        }
        catch (HibernateException ex) {
            throw this.handleException((RuntimeException)((Object)ex));
        }
        finally {
            this.session = null;
        }
    }

    public void invalidateDelegatedSession() throws HibernateException {
        if (this.session != null) {
            try {
                this.session.clear();
                this.session.close();
            }
            catch (HibernateException ex) {
                throw this.handleException((RuntimeException)((Object)ex));
            }
            finally {
                this.session = null;
            }
        }
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }
}

