/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate.classic;

import java.sql.Connection;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.nanocontainer.persistence.hibernate.classic.HibernateExceptionHandler;
import org.nanocontainer.persistence.hibernate.classic.SessionDelegator;
import org.picocontainer.PicoInitializationException;

public class FailoverSessionDelegator
extends SessionDelegator {
    Interceptor interceptor = null;
    Session session = null;
    SessionFactory sessionFactory;

    public FailoverSessionDelegator(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public FailoverSessionDelegator(SessionFactory sessionFactory, HibernateExceptionHandler exceptionHandler) {
        super(exceptionHandler);
        this.setSessionFactory(sessionFactory);
    }

    public FailoverSessionDelegator(SessionFactory sessionFactory, Interceptor interceptor) {
        this(sessionFactory);
        this.setInterceptor(interceptor);
    }

    public FailoverSessionDelegator(SessionFactory sessionFactory, Interceptor interceptor, HibernateExceptionHandler exceptionHandler) {
        this(sessionFactory, exceptionHandler);
        this.setInterceptor(interceptor);
    }

    public Connection close() throws HibernateException {
        Connection retval = null;
        try {
            retval = this.getDelegatedSession().close();
        }
        catch (HibernateException ex) {
            throw ex;
        }
        finally {
            this.session = null;
        }
        return retval;
    }

    public Session getDelegatedSession() {
        if (this.session == null) {
            try {
                this.session = this.interceptor == null ? this.sessionFactory.openSession() : this.sessionFactory.openSession(this.interceptor);
            }
            catch (HibernateException ex) {
                throw new PicoInitializationException((Throwable)ex);
            }
        }
        return this.session;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void invalidateDelegatedSession() throws HibernateException {
        if (this.session != null) {
            try {
                this.session.clear();
                this.session.close();
            }
            catch (HibernateException ex) {
                throw ex;
            }
            finally {
                this.session = null;
            }
        }
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

