/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate.classic;

import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.TransactionException;
import net.sf.hibernate.UnresolvableObjectException;
import net.sf.hibernate.WrongClassException;
import net.sf.hibernate.exception.LockAcquisitionException;
import org.nanocontainer.persistence.ExceptionFactory;

public class HibernateExceptionHandler {
    private ExceptionFactory exceptionFactory;

    public HibernateExceptionHandler(ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    public RuntimeException handle(Throwable ex) {
        if (ex instanceof StaleObjectStateException) {
            StaleObjectStateException e = (StaleObjectStateException)ex;
            return this.exceptionFactory.createStaleObjectStateException((Throwable)e, e.getPersistentClass().getName(), e.getIdentifier());
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException e = (LockAcquisitionException)ex;
            return this.exceptionFactory.createConcurrencyFailureException((Throwable)e);
        }
        if (ex instanceof UnresolvableObjectException) {
            UnresolvableObjectException e = (UnresolvableObjectException)ex;
            return this.exceptionFactory.createObjectRetrievalFailureException((Throwable)e, e.getPersistentClass().getName(), e.getIdentifier());
        }
        if (ex instanceof WrongClassException) {
            WrongClassException e = (WrongClassException)ex;
            return this.exceptionFactory.createObjectRetrievalFailureException((Throwable)e, e.getPersistentClass().getName(), e.getIdentifier());
        }
        if (ex instanceof TransactionException) {
            return this.exceptionFactory.createTransactionException(ex);
        }
        return this.exceptionFactory.createPersistenceException(ex);
    }
}

