/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.hibernate.classic;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;
import org.nanocontainer.persistence.hibernate.classic.HibernateExceptionHandler;

public abstract class SessionDelegator
implements Session {
    private HibernateExceptionHandler exceptionHandler;

    public SessionDelegator() {
        this.exceptionHandler = null;
    }

    public SessionDelegator(HibernateExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected abstract Session getDelegatedSession();

    protected abstract void invalidateDelegatedSession() throws HibernateException;

    protected RuntimeException handleException(HibernateException cause) throws HibernateException {
        try {
            this.invalidateDelegatedSession();
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        if (this.exceptionHandler == null) {
            throw cause;
        }
        return this.exceptionHandler.handle(cause);
    }

    protected RuntimeException handleException(RuntimeException cause) {
        try {
            this.invalidateDelegatedSession();
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        if (this.exceptionHandler == null) {
            return cause;
        }
        return this.exceptionHandler.handle(cause);
    }

    public void flush() throws HibernateException {
        try {
            this.getDelegatedSession().flush();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void setFlushMode(FlushMode flushMode) {
        try {
            this.getDelegatedSession().setFlushMode(flushMode);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public FlushMode getFlushMode() {
        try {
            return this.getDelegatedSession().getFlushMode();
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public SessionFactory getSessionFactory() {
        try {
            return this.getDelegatedSession().getSessionFactory();
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Connection connection() throws HibernateException {
        try {
            return this.getDelegatedSession().connection();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Connection disconnect() throws HibernateException {
        try {
            return this.getDelegatedSession().disconnect();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void reconnect() throws HibernateException {
        try {
            this.getDelegatedSession().reconnect();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void reconnect(Connection connection) throws HibernateException {
        try {
            this.getDelegatedSession().reconnect(connection);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Connection close() throws HibernateException {
        try {
            return this.getDelegatedSession().close();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void cancelQuery() throws HibernateException {
        try {
            this.getDelegatedSession().cancelQuery();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public boolean isOpen() {
        try {
            return this.getDelegatedSession().isOpen();
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public boolean isConnected() {
        try {
            return this.getDelegatedSession().isConnected();
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public boolean isDirty() throws HibernateException {
        try {
            return this.getDelegatedSession().isDirty();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        try {
            return this.getDelegatedSession().getIdentifier(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public boolean contains(Object object) {
        try {
            return this.getDelegatedSession().contains(object);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void evict(Object object) throws HibernateException {
        try {
            this.getDelegatedSession().evict(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        try {
            return this.getDelegatedSession().load(theClass, id, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        try {
            return this.getDelegatedSession().load(theClass, id);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void load(Object object, Serializable id) throws HibernateException {
        try {
            this.getDelegatedSession().load(object, id);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        try {
            this.getDelegatedSession().replicate(object, replicationMode);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Serializable save(Object object) throws HibernateException {
        try {
            return this.getDelegatedSession().save(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void save(Object object, Serializable id) throws HibernateException {
        try {
            this.getDelegatedSession().save(object, id);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        try {
            this.getDelegatedSession().saveOrUpdate(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void update(Object object) throws HibernateException {
        try {
            this.getDelegatedSession().update(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void update(Object object, Serializable id) throws HibernateException {
        try {
            this.getDelegatedSession().update(object, id);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        try {
            return this.getDelegatedSession().saveOrUpdateCopy(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        try {
            return this.getDelegatedSession().saveOrUpdateCopy(object, id);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void delete(Object object) throws HibernateException {
        try {
            this.getDelegatedSession().delete(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public List find(String query) throws HibernateException {
        try {
            return this.getDelegatedSession().find(query);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        try {
            return this.getDelegatedSession().find(query, value, type);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getDelegatedSession().find(query, values, types);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Iterator iterate(String query) throws HibernateException {
        try {
            return this.getDelegatedSession().iterate(query);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        try {
            return this.getDelegatedSession().iterate(query, value, type);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getDelegatedSession().iterate(query, values, types);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        try {
            return this.getDelegatedSession().filter(collection, filter);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        try {
            return this.getDelegatedSession().filter(collection, filter, value, type);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getDelegatedSession().filter(collection, filter, values, types);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public int delete(String query) throws HibernateException {
        try {
            return this.getDelegatedSession().delete(query);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        try {
            return this.getDelegatedSession().delete(query, value, type);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        try {
            return this.getDelegatedSession().delete(query, values, types);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        try {
            this.getDelegatedSession().lock(object, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void refresh(Object object) throws HibernateException {
        try {
            this.getDelegatedSession().refresh(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        try {
            this.getDelegatedSession().refresh(object, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        try {
            return this.getDelegatedSession().getCurrentLockMode(object);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Transaction beginTransaction() throws HibernateException {
        try {
            return this.getDelegatedSession().beginTransaction();
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Criteria createCriteria(Class persistentClass) {
        try {
            return this.getDelegatedSession().createCriteria(persistentClass);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Query createQuery(String queryString) throws HibernateException {
        try {
            return this.getDelegatedSession().createQuery(queryString);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        try {
            return this.getDelegatedSession().createFilter(collection, queryString);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Query getNamedQuery(String queryName) throws HibernateException {
        try {
            return this.getDelegatedSession().getNamedQuery(queryName);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        try {
            return this.getDelegatedSession().createSQLQuery(sql, returnAlias, returnClass);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        try {
            return this.getDelegatedSession().createSQLQuery(sql, returnAliases, returnClasses);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public void clear() {
        try {
            this.getDelegatedSession().clear();
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        try {
            return this.getDelegatedSession().get(clazz, id);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        try {
            return this.getDelegatedSession().get(clazz, id, lockMode);
        }
        catch (HibernateException ex) {
            throw this.handleException(ex);
        }
        catch (RuntimeException ex) {
            throw this.handleException(ex);
        }
    }
}

