/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.nanocontainer.persistence.ExceptionHandler;

public abstract class AbstractDataSource
implements DataSource {
    private final ExceptionHandler jdbcExceptionHandler;

    protected AbstractDataSource(ExceptionHandler jdbcExceptionHandler) {
        this.jdbcExceptionHandler = jdbcExceptionHandler;
    }

    protected AbstractDataSource() {
        this.jdbcExceptionHandler = null;
    }

    protected abstract DataSource getDelegatedDataSource() throws Exception;

    protected abstract void invalidateDelegatedDataSource() throws Exception;

    protected SQLException handleException(Exception cause) throws RuntimeException {
        try {
            this.invalidateDelegatedDataSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.jdbcExceptionHandler == null) {
            if (cause instanceof SQLException) {
                return (SQLException)cause;
            }
            if (cause instanceof Exception) {
                throw new RuntimeException(cause);
            }
            throw (RuntimeException)cause;
        }
        throw this.jdbcExceptionHandler.handle(cause);
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.getDelegatedDataSource().getConnection();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        try {
            return this.getDelegatedDataSource().getConnection(username, password);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        try {
            return this.getDelegatedDataSource().getLogWriter();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        try {
            this.getDelegatedDataSource().setLogWriter(out);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        try {
            this.getDelegatedDataSource().setLoginTimeout(seconds);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public int getLoginTimeout() throws SQLException {
        try {
            return this.getDelegatedDataSource().getLoginTimeout();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }
}

