/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.jdbc;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.nanocontainer.persistence.ExceptionHandler;
import org.nanocontainer.persistence.jdbc.AbstractDataSource;
import org.picocontainer.Startable;

public class DBCPDataSource
extends AbstractDataSource
implements Startable {
    private BasicDataSource dataSource;
    private final Properties properties;

    public DBCPDataSource(String driver, String connectionURL, String username, String password) {
        this.properties = new Properties();
        this.properties.put("driverClassName", driver);
        this.properties.put("url", connectionURL);
        this.properties.put("username", username);
        this.properties.put("password", password);
    }

    public DBCPDataSource(String driver, String connectionURL, String username, String password, ExceptionHandler jdbcExceptionHandler) {
        super(jdbcExceptionHandler);
        this.properties = new Properties();
        this.properties.put("driverClassName", driver);
        this.properties.put("url", connectionURL);
        this.properties.put("username", username);
        this.properties.put("password", password);
    }

    public DBCPDataSource(Properties properties) {
        this.properties = properties;
    }

    public DBCPDataSource(Properties properties, ExceptionHandler jdbcExceptionHandler) {
        super(jdbcExceptionHandler);
        this.properties = properties;
    }

    protected DataSource getDelegatedDataSource() throws Exception {
        if (this.dataSource == null) {
            this.dataSource = (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)this.properties);
        }
        return this.dataSource;
    }

    protected void invalidateDelegatedDataSource() throws Exception {
        this.dataSource.close();
        this.dataSource = null;
    }

    public void start() {
    }

    public void stop() {
        try {
            this.dataSource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dataSource = null;
    }
}

