/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.nanocontainer.persistence.ExceptionHandler;
import org.nanocontainer.persistence.jdbc.AbstractConnection;
import org.picocontainer.Startable;

public class FailoverDataSourceConnection
extends AbstractConnection
implements Startable {
    private DataSource dataSource;
    private Connection connection;

    public FailoverDataSourceConnection(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public FailoverDataSourceConnection(DataSource dataSource, ExceptionHandler exceptionHandler) {
        super(exceptionHandler);
        this.dataSource = dataSource;
    }

    protected Connection getDelegatedConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        return this.connection;
    }

    protected void invalidateDelegatedConnection() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
    }

    public void start() {
    }

    public void stop() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

