/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.persistence.jdbc;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.nanocontainer.persistence.ExceptionHandler;
import org.nanocontainer.persistence.jdbc.AbstractDataSource;
import org.picocontainer.Startable;

public class JNDIDataSource
extends AbstractDataSource
implements Startable {
    private final String name;
    private final Context context;
    private DataSource dataSource;

    public JNDIDataSource(String name) {
        this.name = name;
        this.context = null;
    }

    public JNDIDataSource(String name, ExceptionHandler jdbcExceptionHandler) {
        super(jdbcExceptionHandler);
        this.name = name;
        this.context = null;
    }

    public JNDIDataSource(String name, Context context) {
        this.name = name;
        this.context = context;
    }

    public JNDIDataSource(String name, Context context, ExceptionHandler jdbcExceptionHandler) {
        super(jdbcExceptionHandler);
        this.name = name;
        this.context = context;
    }

    protected DataSource getDelegatedDataSource() throws Exception {
        if (this.dataSource == null) {
            Context jndiContext = this.context == null ? new InitialContext() : this.context;
            this.dataSource = (DataSource)jndiContext.lookup(this.name);
        }
        return this.dataSource;
    }

    protected void invalidateDelegatedDataSource() throws Exception {
        this.dataSource = null;
    }

    public void start() {
    }

    public void stop() {
        this.dataSource = null;
    }
}

