/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.UploadContext;

public class NanoFileUpload
extends FileUpload {
    public static final boolean isMultipartContent(NanoHTTPD.IHTTPSession session) {
        return session.getMethod() == NanoHTTPD.Method.POST && FileUploadBase.isMultipartContent((RequestContext)new NanoHttpdContext(session));
    }

    public NanoFileUpload(FileItemFactory fileItemFactory) {
        super(fileItemFactory);
    }

    public List<FileItem> parseRequest(NanoHTTPD.IHTTPSession session) throws FileUploadException {
        return this.parseRequest((RequestContext)new NanoHttpdContext(session));
    }

    public Map<String, List<FileItem>> parseParameterMap(NanoHTTPD.IHTTPSession session) throws FileUploadException {
        return this.parseParameterMap((RequestContext)new NanoHttpdContext(session));
    }

    public FileItemIterator getItemIterator(NanoHTTPD.IHTTPSession session) throws FileUploadException, IOException {
        return super.getItemIterator((RequestContext)new NanoHttpdContext(session));
    }

    public static class NanoHttpdContext
    implements UploadContext {
        private NanoHTTPD.IHTTPSession session;

        public NanoHttpdContext(NanoHTTPD.IHTTPSession session) {
            this.session = session;
        }

        public long contentLength() {
            long size;
            try {
                String cl1 = (String)this.session.getHeaders().get("content-length");
                size = Long.parseLong(cl1);
            }
            catch (NumberFormatException var4) {
                size = -1L;
            }
            return size;
        }

        public String getCharacterEncoding() {
            return "UTF-8";
        }

        public String getContentType() {
            return (String)this.session.getHeaders().get("content-type");
        }

        public int getContentLength() {
            return (int)this.contentLength();
        }

        public InputStream getInputStream() throws IOException {
            return this.session.getInputStream();
        }
    }
}

