/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.WebServerPlugin;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pegdown.PegDownProcessor;

public class MarkdownWebServerPlugin
implements WebServerPlugin {
    private static final Logger LOG = Logger.getLogger(MarkdownWebServerPlugin.class.getName());
    private final PegDownProcessor processor = new PegDownProcessor();

    public boolean canServeUri(String uri, File rootDir) {
        File f = new File(rootDir, uri);
        return f.exists();
    }

    public void initialize(Map<String, String> commandLineOptions) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSource(File file) {
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            String line = null;
            StringBuilder sb = new StringBuilder();
            do {
                if ((line = reader.readLine()) == null) continue;
                sb.append(line).append("\n");
            } while (line != null);
            reader.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "could not read source", e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ignored) {
                LOG.log(Level.FINEST, "close failed", ignored);
            }
        }
    }

    public NanoHTTPD.Response serveFile(String uri, Map<String, String> headers, NanoHTTPD.IHTTPSession session, File file, String mimeType) {
        byte[] bytes;
        String markdownSource = this.readSource(file);
        try {
            bytes = this.processor.markdownToHtml(markdownSource).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "encoding problem, responding nothing", e);
            bytes = new byte[]{};
        }
        return markdownSource == null ? null : new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/html", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length);
    }
}

