/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.InternalRewrite;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.WebServerPlugin;
import fi.iki.elonen.WebServerPluginInfo;
import fi.iki.elonen.util.ServerRunner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringTokenizer;

public class SimpleWebServer
extends NanoHTTPD {
    public static final List<String> INDEX_FILE_NAMES;
    private static final String LICENCE;
    private static Map<String, WebServerPlugin> mimeTypeHandlers;
    private final boolean quiet;
    private final String cors;
    protected List<File> rootDirs;
    private static final String ALLOWED_METHODS = "GET, POST, PUT, DELETE, OPTIONS, HEAD";
    private static final int MAX_AGE = 151200;
    static final String DEFAULT_ALLOWED_HEADERS = "origin,accept,content-type";
    public static final String ACCESS_CONTROL_ALLOW_HEADER_PROPERTY_NAME = "AccessControlAllowHeader";

    public static void main(String[] args) {
        int port = 8080;
        String host = null;
        ArrayList<File> rootDirs = new ArrayList<File>();
        boolean quiet = false;
        String cors = null;
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            int dot;
            if ("-h".equalsIgnoreCase(args[i]) || "--host".equalsIgnoreCase(args[i])) {
                host = args[i + 1];
                continue;
            }
            if ("-p".equalsIgnoreCase(args[i]) || "--port".equalsIgnoreCase(args[i])) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if ("-q".equalsIgnoreCase(args[i]) || "--quiet".equalsIgnoreCase(args[i])) {
                quiet = true;
                continue;
            }
            if ("-d".equalsIgnoreCase(args[i]) || "--dir".equalsIgnoreCase(args[i])) {
                rootDirs.add(new File(args[i + 1]).getAbsoluteFile());
                continue;
            }
            if (args[i].startsWith("--cors")) {
                cors = "*";
                int equalIdx = args[i].indexOf(61);
                if (equalIdx <= 0) continue;
                cors = args[i].substring(equalIdx + 1);
                continue;
            }
            if ("--licence".equalsIgnoreCase(args[i])) {
                System.out.println(LICENCE + "\n");
                continue;
            }
            if (!args[i].startsWith("-X:") || (dot = args[i].indexOf(61)) <= 0) continue;
            String name = args[i].substring(0, dot);
            String value = args[i].substring(dot + 1, args[i].length());
            options.put(name, value);
        }
        if (rootDirs.isEmpty()) {
            rootDirs.add(new File(".").getAbsoluteFile());
        }
        options.put("host", host);
        options.put("port", "" + port);
        options.put("quiet", String.valueOf(quiet));
        StringBuilder sb = new StringBuilder();
        for (File dir : rootDirs) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            try {
                sb.append(dir.getCanonicalPath());
            }
            catch (IOException ignored) {}
        }
        options.put("home", sb.toString());
        ServiceLoader<WebServerPluginInfo> serviceLoader = ServiceLoader.load(WebServerPluginInfo.class);
        for (WebServerPluginInfo info : serviceLoader) {
            String[] mimeTypes;
            for (String mime : mimeTypes = info.getMimeTypes()) {
                String[] indexFiles = info.getIndexFilesForMimeType(mime);
                if (!quiet) {
                    System.out.print("# Found plugin for Mime type: \"" + mime + "\"");
                    if (indexFiles != null) {
                        System.out.print(" (serving index files: ");
                        for (String indexFile : indexFiles) {
                            System.out.print(indexFile + " ");
                        }
                    }
                    System.out.println(").");
                }
                SimpleWebServer.registerPluginForMimeType(indexFiles, mime, info.getWebServerPlugin(mime), options);
            }
        }
        ServerRunner.executeInstance((NanoHTTPD)new SimpleWebServer(host, port, rootDirs, quiet, cors));
    }

    protected static void registerPluginForMimeType(String[] indexFiles, String mimeType, WebServerPlugin plugin, Map<String, String> commandLineOptions) {
        if (mimeType == null || plugin == null) {
            return;
        }
        if (indexFiles != null) {
            for (String filename : indexFiles) {
                int dot = filename.lastIndexOf(46);
                if (dot < 0) continue;
                String extension = filename.substring(dot + 1).toLowerCase();
                SimpleWebServer.mimeTypes().put(extension, mimeType);
            }
            INDEX_FILE_NAMES.addAll(Arrays.asList(indexFiles));
        }
        mimeTypeHandlers.put(mimeType, plugin);
        plugin.initialize(commandLineOptions);
    }

    public SimpleWebServer(String host, int port, File wwwroot, boolean quiet, String cors) {
        this(host, port, Collections.singletonList(wwwroot), quiet, cors);
    }

    public SimpleWebServer(String host, int port, File wwwroot, boolean quiet) {
        this(host, port, Collections.singletonList(wwwroot), quiet, null);
    }

    public SimpleWebServer(String host, int port, List<File> wwwroots, boolean quiet) {
        this(host, port, wwwroots, quiet, null);
    }

    public SimpleWebServer(String host, int port, List<File> wwwroots, boolean quiet, String cors) {
        super(host, port);
        this.quiet = quiet;
        this.cors = cors;
        this.rootDirs = new ArrayList<File>(wwwroots);
        this.init();
    }

    private boolean canServeUri(String uri, File homeDir) {
        WebServerPlugin plugin;
        File f = new File(homeDir, uri);
        boolean canServeUri = f.exists();
        if (!canServeUri && (plugin = mimeTypeHandlers.get(SimpleWebServer.getMimeTypeForFile((String)uri))) != null) {
            canServeUri = plugin.canServeUri(uri, homeDir);
        }
        return canServeUri;
    }

    private String encodeUri(String uri) {
        String newUri = "";
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if ("/".equals(tok)) {
                newUri = newUri + "/";
                continue;
            }
            if (" ".equals(tok)) {
                newUri = newUri + "%20";
                continue;
            }
            try {
                newUri = newUri + URLEncoder.encode(tok, "UTF-8");
            }
            catch (UnsupportedEncodingException ignored) {}
        }
        return newUri;
    }

    private String findIndexFileInDirectory(File directory) {
        for (String fileName : INDEX_FILE_NAMES) {
            File indexFile = new File(directory, fileName);
            if (!indexFile.isFile()) continue;
            return fileName;
        }
        return null;
    }

    protected NanoHTTPD.Response getForbiddenResponse(String s) {
        return SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.FORBIDDEN, "text/plain", "FORBIDDEN: " + s);
    }

    protected NanoHTTPD.Response getInternalErrorResponse(String s) {
        return SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "INTERNAL ERROR: " + s);
    }

    protected NanoHTTPD.Response getNotFoundResponse() {
        return SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "Error 404, file not found.");
    }

    public void init() {
    }

    protected String listDirectory(String uri, File f) {
        String u;
        int slash;
        String heading = "Directory " + uri;
        StringBuilder msg = new StringBuilder("<html><head><title>" + heading + "</title><style><!--\n" + "span.dirname { font-weight: bold; }\n" + "span.filesize { font-size: 75%; }\n" + "// -->\n" + "</style>" + "</head><body><h1>" + heading + "</h1>");
        String up = null;
        if (uri.length() > 1 && (slash = (u = uri.substring(0, uri.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
            up = uri.substring(0, slash + 1);
        }
        List<String> files = Arrays.asList(f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isFile();
            }
        }));
        Collections.sort(files);
        List<String> directories = Arrays.asList(f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory();
            }
        }));
        Collections.sort(directories);
        if (up != null || directories.size() + files.size() > 0) {
            msg.append("<ul>");
            if (up != null || directories.size() > 0) {
                msg.append("<section class=\"directories\">");
                if (up != null) {
                    msg.append("<li><a rel=\"directory\" href=\"").append(up).append("\"><span class=\"dirname\">..</span></a></b></li>");
                }
                for (String directory : directories) {
                    String dir = directory + "/";
                    msg.append("<li><a rel=\"directory\" href=\"").append(this.encodeUri(uri + dir)).append("\"><span class=\"dirname\">").append(dir).append("</span></a></b></li>");
                }
                msg.append("</section>");
            }
            if (files.size() > 0) {
                msg.append("<section class=\"files\">");
                for (String file : files) {
                    msg.append("<li><a href=\"").append(this.encodeUri(uri + file)).append("\"><span class=\"filename\">").append(file).append("</span></a>");
                    File curFile = new File(f, file);
                    long len = curFile.length();
                    msg.append("&nbsp;<span class=\"filesize\">(");
                    if (len < 1024L) {
                        msg.append(len).append(" bytes");
                    } else if (len < 0x100000L) {
                        msg.append(len / 1024L).append(".").append(len % 1024L / 10L % 100L).append(" KB");
                    } else {
                        msg.append(len / 0x100000L).append(".").append(len % 0x100000L / 10000L % 100L).append(" MB");
                    }
                    msg.append(")</span></li>");
                }
                msg.append("</section>");
            }
            msg.append("</ul>");
        }
        msg.append("</body></html>");
        return msg.toString();
    }

    public static NanoHTTPD.Response newFixedLengthResponse(NanoHTTPD.Response.IStatus status, String mimeType, String message) {
        NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)status, (String)mimeType, (String)message);
        response.addHeader("Accept-Ranges", "bytes");
        return response;
    }

    private NanoHTTPD.Response respond(Map<String, String> headers, NanoHTTPD.IHTTPSession session, String uri) {
        NanoHTTPD.Response r = this.cors != null && NanoHTTPD.Method.OPTIONS.equals((Object)session.getMethod()) ? new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain", null, 0L) : this.defaultRespond(headers, session, uri);
        if (this.cors != null) {
            r = this.addCORSHeaders(headers, r, this.cors);
        }
        return r;
    }

    private NanoHTTPD.Response defaultRespond(Map<String, String> headers, NanoHTTPD.IHTTPSession session, String uri) {
        if ((uri = uri.trim().replace(File.separatorChar, '/')).indexOf(63) >= 0) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        if (uri.contains("../")) {
            return this.getForbiddenResponse("Won't serve ../ for security reasons.");
        }
        boolean canServeUri = false;
        File homeDir = null;
        for (int i = 0; !canServeUri && i < this.rootDirs.size(); ++i) {
            homeDir = this.rootDirs.get(i);
            canServeUri = this.canServeUri(uri, homeDir);
        }
        if (!canServeUri) {
            return this.getNotFoundResponse();
        }
        File f = new File(homeDir, uri);
        if (f.isDirectory() && !uri.endsWith("/")) {
            uri = uri + "/";
            NanoHTTPD.Response res = SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.REDIRECT, "text/html", "<html><body>Redirected: <a href=\"" + uri + "\">" + uri + "</a></body></html>");
            res.addHeader("Location", uri);
            return res;
        }
        if (f.isDirectory()) {
            String indexFile = this.findIndexFileInDirectory(f);
            if (indexFile == null) {
                if (f.canRead()) {
                    return SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/html", this.listDirectory(uri, f));
                }
                return this.getForbiddenResponse("No directory listing.");
            }
            return this.respond(headers, session, uri + indexFile);
        }
        String mimeTypeForFile = SimpleWebServer.getMimeTypeForFile((String)uri);
        WebServerPlugin plugin = mimeTypeHandlers.get(mimeTypeForFile);
        NanoHTTPD.Response response = null;
        if (plugin != null && plugin.canServeUri(uri, homeDir)) {
            response = plugin.serveFile(uri, headers, session, f, mimeTypeForFile);
            if (response != null && response instanceof InternalRewrite) {
                InternalRewrite rewrite = (InternalRewrite)response;
                return this.respond(rewrite.getHeaders(), session, rewrite.getUri());
            }
        } else {
            response = this.serveFile(uri, headers, f, mimeTypeForFile);
        }
        return response != null ? response : this.getNotFoundResponse();
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        Map header = session.getHeaders();
        Map parms = session.getParms();
        String uri = session.getUri();
        if (!this.quiet) {
            System.out.println(session.getMethod() + " '" + uri + "' ");
            for (String value : header.keySet()) {
                System.out.println("  HDR: '" + value + "' = '" + (String)header.get(value) + "'");
            }
            for (String value : parms.keySet()) {
                System.out.println("  PRM: '" + value + "' = '" + (String)parms.get(value) + "'");
            }
        }
        for (File homeDir : this.rootDirs) {
            if (homeDir.isDirectory()) continue;
            return this.getInternalErrorResponse("given path is not a directory (" + homeDir + ").");
        }
        return this.respond(Collections.unmodifiableMap(header), session, uri);
    }

    NanoHTTPD.Response serveFile(String uri, Map<String, String> header, File file, String mime) {
        NanoHTTPD.Response res;
        try {
            String ifRange;
            String etag = Integer.toHexString((file.getAbsolutePath() + file.lastModified() + "" + file.length()).hashCode());
            long startFrom = 0L;
            long endAt = -1L;
            String range = header.get("range");
            if (range != null && range.startsWith("bytes=")) {
                range = range.substring("bytes=".length());
                int minus = range.indexOf(45);
                try {
                    if (minus > 0) {
                        startFrom = Long.parseLong(range.substring(0, minus));
                        endAt = Long.parseLong(range.substring(minus + 1));
                    }
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            boolean headerIfRangeMissingOrMatching = (ifRange = header.get("if-range")) == null || etag.equals(ifRange);
            String ifNoneMatch = header.get("if-none-match");
            boolean headerIfNoneMatchPresentAndMatching = ifNoneMatch != null && ("*".equals(ifNoneMatch) || ifNoneMatch.equals(etag));
            long fileLen = file.length();
            if (headerIfRangeMissingOrMatching && range != null && startFrom >= 0L && startFrom < fileLen) {
                if (headerIfNoneMatchPresentAndMatching) {
                    res = SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, mime, "");
                    res.addHeader("ETag", etag);
                } else {
                    long newLen;
                    if (endAt < 0L) {
                        endAt = fileLen - 1L;
                    }
                    if ((newLen = endAt - startFrom + 1L) < 0L) {
                        newLen = 0L;
                    }
                    FileInputStream fis = new FileInputStream(file);
                    fis.skip(startFrom);
                    res = SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.PARTIAL_CONTENT, (String)mime, (InputStream)fis, (long)newLen);
                    res.addHeader("Accept-Ranges", "bytes");
                    res.addHeader("Content-Length", "" + newLen);
                    res.addHeader("Content-Range", "bytes " + startFrom + "-" + endAt + "/" + fileLen);
                    res.addHeader("ETag", etag);
                }
            } else if (headerIfRangeMissingOrMatching && range != null && startFrom >= fileLen) {
                res = SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE, "text/plain", "");
                res.addHeader("Content-Range", "bytes */" + fileLen);
                res.addHeader("ETag", etag);
            } else if (range == null && headerIfNoneMatchPresentAndMatching) {
                res = SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, mime, "");
                res.addHeader("ETag", etag);
            } else if (!headerIfRangeMissingOrMatching && headerIfNoneMatchPresentAndMatching) {
                res = SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED, mime, "");
                res.addHeader("ETag", etag);
            } else {
                res = this.newFixedFileResponse(file, mime);
                res.addHeader("Content-Length", "" + fileLen);
                res.addHeader("ETag", etag);
            }
        }
        catch (IOException ioe) {
            res = this.getForbiddenResponse("Reading file failed.");
        }
        return res;
    }

    private NanoHTTPD.Response newFixedFileResponse(File file, String mime) throws FileNotFoundException {
        NanoHTTPD.Response res = SimpleWebServer.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)mime, (InputStream)new FileInputStream(file), (long)((int)file.length()));
        res.addHeader("Accept-Ranges", "bytes");
        return res;
    }

    protected NanoHTTPD.Response addCORSHeaders(Map<String, String> queryHeaders, NanoHTTPD.Response resp, String cors) {
        resp.addHeader("Access-Control-Allow-Origin", cors);
        resp.addHeader("Access-Control-Allow-Headers", this.calculateAllowHeaders(queryHeaders));
        resp.addHeader("Access-Control-Allow-Credentials", "true");
        resp.addHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
        resp.addHeader("Access-Control-Max-Age", "151200");
        return resp;
    }

    private String calculateAllowHeaders(Map<String, String> queryHeaders) {
        return System.getProperty(ACCESS_CONTROL_ALLOW_HEADER_PROPERTY_NAME, DEFAULT_ALLOWED_HEADERS);
    }

    static {
        String text;
        INDEX_FILE_NAMES = new ArrayList<String>(){
            {
                this.add("index.html");
                this.add("index.htm");
            }
        };
        SimpleWebServer.mimeTypes();
        try {
            int count;
            InputStream stream = SimpleWebServer.class.getResourceAsStream("/LICENSE.txt");
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) >= 0) {
                bytes.write(buffer, 0, count);
            }
            text = bytes.toString("UTF-8");
        }
        catch (Exception e) {
            text = "unknown";
        }
        LICENCE = text;
        mimeTypeHandlers = new HashMap<String, WebServerPlugin>();
    }
}

