/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen.samples.echo;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.NanoWSD;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugWebSocketServer
extends NanoWSD {
    private static final Logger LOG = Logger.getLogger(DebugWebSocketServer.class.getName());
    private final boolean debug;

    public DebugWebSocketServer(int port, boolean debug) {
        super(port);
        this.debug = debug;
    }

    @Override
    protected NanoWSD.WebSocket openWebSocket(NanoHTTPD.IHTTPSession handshake) {
        return new DebugWebSocket(this, handshake);
    }

    private static class DebugWebSocket
    extends NanoWSD.WebSocket {
        private final DebugWebSocketServer server;

        public DebugWebSocket(DebugWebSocketServer server, NanoHTTPD.IHTTPSession handshakeRequest) {
            super(handshakeRequest);
            this.server = server;
        }

        @Override
        protected void onOpen() {
        }

        @Override
        protected void onClose(NanoWSD.WebSocketFrame.CloseCode code, String reason, boolean initiatedByRemote) {
            if (this.server.debug) {
                System.out.println("C [" + (initiatedByRemote ? "Remote" : "Self") + "] " + (code != null ? code : "UnknownCloseCode[" + (Object)((Object)code) + "]") + (reason != null && !reason.isEmpty() ? ": " + reason : ""));
            }
        }

        @Override
        protected void onMessage(NanoWSD.WebSocketFrame message) {
            try {
                message.setUnmasked();
                this.sendFrame(message);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void onPong(NanoWSD.WebSocketFrame pong) {
            if (this.server.debug) {
                System.out.println("P " + pong);
            }
        }

        @Override
        protected void onException(IOException exception) {
            LOG.log(Level.SEVERE, "exception occured", exception);
        }

        @Override
        protected void debugFrameReceived(NanoWSD.WebSocketFrame frame) {
            if (this.server.debug) {
                System.out.println("R " + frame);
            }
        }

        @Override
        protected void debugFrameSent(NanoWSD.WebSocketFrame frame) {
            if (this.server.debug) {
                System.out.println("S " + frame);
            }
        }
    }
}

