/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanmapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class TypeConvertor {
    private static final TypeConvertor instance = new TypeConvertor();
    public static final int DATE_ONLY = 1;
    public static final int TIME_ONLY = 2;
    public static final int DATE_AND_TIME = 3;
    private static final String DATE_ISO_FORMAT = "yyyy-MM-dd";
    private static final String DATE_TIME_ISO_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_ISO_FORMAT = "HH:mm:ss";
    private static final String ERROR_VALUE_IS_NULL = "Value argument is null";
    private static final String ERROR_VALUE_IS_INVALID = "Value argument is invalid";

    TypeConvertor() {
    }

    public static final TypeConvertor getInstance() {
        return instance;
    }

    private boolean isNullOrVoidOrBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    private void checkParamNotNull(Object o) {
        if (null == o) {
            throw new IllegalArgumentException(ERROR_VALUE_IS_NULL);
        }
    }

    private void throwException(String sMessage) {
        throw new RuntimeException("Type conversion error : " + sMessage);
    }

    public boolean toBooleanPrimitive(String sValue) {
        this.checkParamNotNull(sValue);
        if (sValue.equals("1")) {
            return true;
        }
        return sValue.equalsIgnoreCase("true");
    }

    public long toLongPrimitive(String sValue) {
        this.checkParamNotNull(sValue);
        return Long.parseLong(sValue);
    }

    public long toLongPrimitive(String sValue, long defaultValue) {
        if (this.isNullOrVoidOrBlank(sValue)) {
            return defaultValue;
        }
        return Long.parseLong(sValue);
    }

    public int toIntPrimitive(String sValue) {
        this.checkParamNotNull(sValue);
        return Integer.parseInt(sValue);
    }

    public int toIntPrimitive(String sValue, int defaultValue) {
        if (this.isNullOrVoidOrBlank(sValue)) {
            return defaultValue;
        }
        return Integer.parseInt(sValue);
    }

    public short toShortPrimitive(String sValue) {
        this.checkParamNotNull(sValue);
        return Short.parseShort(sValue);
    }

    public short toShortPrimitive(String sValue, short defaultValue) {
        if (this.isNullOrVoidOrBlank(sValue)) {
            return defaultValue;
        }
        return Short.parseShort(sValue);
    }

    public byte toBytePrimitive(String sValue) {
        this.checkParamNotNull(sValue);
        return Byte.parseByte(sValue);
    }

    public byte toBytePrimitive(String sValue, byte defaultValue) {
        if (this.isNullOrVoidOrBlank(sValue)) {
            return defaultValue;
        }
        return Byte.parseByte(sValue);
    }

    public double toDoublePrimitive(String sValue) {
        this.checkParamNotNull(sValue);
        return Double.parseDouble(sValue);
    }

    public double toDoublePrimitive(String sValue, double defaultValue) {
        if (this.isNullOrVoidOrBlank(sValue)) {
            return defaultValue;
        }
        return Double.parseDouble(sValue);
    }

    public float toFloatPrimitive(String sValue) {
        this.checkParamNotNull(sValue);
        return Float.parseFloat(sValue);
    }

    public float toFloatPrimitive(String sValue, float defaultValue) {
        if (this.isNullOrVoidOrBlank(sValue)) {
            return defaultValue;
        }
        return Float.parseFloat(sValue);
    }

    private Date parseDateOrTime(String sDate, String format) {
        Date ret = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setLenient(false);
            ret = dateFormat.parse(sDate);
        }
        catch (ParseException e) {
            this.throwException("Cannot parse date ( format '" + format + "' )");
        }
        return ret;
    }

    private String formatDateOrTime(Date date, String format) {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.format(date);
        }
        return "";
    }

    public Date toUtilDateObject(String sValue) {
        if (sValue != null) {
            String sTrim = sValue.trim();
            int length = sTrim.length();
            if (length == 0) {
                return null;
            }
            if (length == 10) {
                return this.parseDateOrTime(sTrim, DATE_ISO_FORMAT);
            }
            if (length == 8) {
                return this.parseDateOrTime(sTrim, TIME_ISO_FORMAT);
            }
            if (length == 19) {
                return this.parseDateOrTime(sTrim, DATE_TIME_ISO_FORMAT);
            }
            this.throwException("Invalid value '" + sTrim + "' ");
        }
        return null;
    }

    public java.sql.Date toSqlDateObject(String sValue) {
        if (sValue != null) {
            String sDateTrim = sValue.trim();
            int length = sDateTrim.length();
            if (length == 0) {
                return null;
            }
            if (length == 10) {
                Date ud = this.parseDateOrTime(sDateTrim, DATE_ISO_FORMAT);
                return new java.sql.Date(ud.getTime());
            }
            this.throwException("Value argument is invalid '" + sDateTrim + "' ");
        }
        return null;
    }

    public Time toSqlTimeObject(String sValue) {
        if (sValue != null) {
            String sTrim = sValue.trim();
            int length = sTrim.length();
            if (length == 0) {
                return null;
            }
            if (length == 8) {
                Date ud = this.parseDateOrTime(sTrim, TIME_ISO_FORMAT);
                return new Time(ud.getTime());
            }
            this.throwException("Invalid time value '" + sTrim + "' ");
        }
        return null;
    }

    public Timestamp toSqlTimestampObject(String sValue) {
        if (sValue != null) {
            String sTrim = sValue.trim();
            int length = sTrim.length();
            if (length == 0) {
                return null;
            }
            if (length == 19) {
                Date ud = this.parseDateOrTime(sTrim, DATE_TIME_ISO_FORMAT);
                return new Timestamp(ud.getTime());
            }
            this.throwException("Invalid Timestamp value '" + sTrim + "' ");
        }
        return null;
    }

    public Boolean toBooleanObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : Boolean.valueOf(this.toBooleanPrimitive(sValue));
    }

    public Byte toByteObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : Byte.valueOf(sValue.trim());
    }

    public Short toShortObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : Short.valueOf(sValue.trim());
    }

    public Integer toIntegerObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : Integer.valueOf(sValue.trim());
    }

    public Long toLongObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : Long.valueOf(sValue.trim());
    }

    public Float toFloatObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : Float.valueOf(sValue.trim());
    }

    public Double toDoubleObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : Double.valueOf(sValue.trim());
    }

    public BigDecimal toBigDecimalObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : new BigDecimal(sValue.trim());
    }

    public BigInteger toBigIntegerObject(String sValue) {
        return this.isNullOrVoidOrBlank(sValue) ? null : new BigInteger(sValue.trim());
    }

    public String toString(Date date) {
        return this.toString(date, 1);
    }

    public String toString(Date date, int iType) {
        if (date == null) {
            return "";
        }
        if (iType == 3) {
            return this.formatDateOrTime(date, DATE_TIME_ISO_FORMAT);
        }
        if (iType == 2) {
            return this.formatDateOrTime(date, TIME_ISO_FORMAT);
        }
        return this.formatDateOrTime(date, DATE_ISO_FORMAT);
    }

    public String toString(java.sql.Date d) {
        return d != null ? d.toString() : "";
    }

    public String toString(Time t) {
        return t != null ? t.toString() : "";
    }

    public String toString(Timestamp ts) {
        return this.formatDateOrTime(ts, DATE_TIME_ISO_FORMAT);
    }

    public String toString(Boolean v) {
        return v != null ? v.toString() : "";
    }

    public String toString(Byte v) {
        return v != null ? v.toString() : "";
    }

    public String toString(Short v) {
        return v != null ? v.toString() : "";
    }

    public String toString(Integer v) {
        return v != null ? v.toString() : "";
    }

    public String toString(Long v) {
        return v != null ? v.toString() : "";
    }

    public String toString(Float v) {
        return v != null ? v.toString() : "";
    }

    public String toString(Double v) {
        return v != null ? v.toString() : "";
    }

    public String toString(BigDecimal v) {
        return v != null ? v.toString() : "";
    }

    public String toString(BigInteger v) {
        return v != null ? v.toString() : "";
    }

    public String toString(Character v) {
        return v != null ? v.toString() : "";
    }
}

