/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.nanoj.util.beanwriter.BeanTranslator;
import org.nanoj.util.beanwriter.util.JsonUtil;

public class JsonBeanTranslator
implements BeanTranslator {
    private static final String END_OF_LINE = "\n";
    private int[] levelCount = new int[1024];
    private int currentLevel = 0;
    private boolean formattedOutput = false;

    public JsonBeanTranslator() {
        this.formattedOutput = false;
    }

    public JsonBeanTranslator(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    @Override
    public void open(Writer output) {
        this.currentLevel = 0;
        this.write(output, "{ ");
    }

    @Override
    public void close(Writer output) {
        this.write(output, END_OF_LINE);
        this.write(output, "}");
        this.currentLevel = 0;
    }

    @Override
    public void openSubObjects(Writer output, Object bean, String name) {
    }

    @Override
    public void closeSubObjects(Writer output, Object bean, String name) {
    }

    @Override
    public void openObject(Writer output, Object bean, String name) {
        this.openLevel(output, "{", name);
    }

    @Override
    public void closeObject(Writer output, Object bean, String name, int subObjectsCount) {
        this.closeLevel(output, "}");
    }

    @Override
    public void writeComment(Writer output, String comment) {
        this.writeNewLine(output);
        this.write(output, "/* " + comment + " */");
    }

    @Override
    public void writeNullValue(Writer output, String name, Object parent) {
        this.writeBasicValue(output, name, "null");
    }

    @Override
    public void writeValue(Writer output, Object obj, String name, Object parent) {
        String sValue = JsonUtil.jsonObjectValue(obj);
        this.writeBasicValue(output, name, sValue);
    }

    @Override
    public void writeSubElementValue(Writer output, Object value, String name, Object parent) {
        String sValue = JsonUtil.jsonObjectValue(value);
        this.writeBasicValue(output, name, sValue);
    }

    private void writeBasicValue(Writer output, String name, String value) {
        if (this.isNotFirstValueInCurrentLevel()) {
            this.write(output, ", ");
        }
        this.writeNewLine(output);
        if (name != null) {
            this.write(output, "\"" + name + "\" : " + value + " ");
        } else {
            this.write(output, value + " ");
        }
        this.incrementValueInCurrentLevel();
    }

    private void writeNewLine(Writer output) {
        if (this.formattedOutput) {
            this.write(output, END_OF_LINE);
            for (int i = 0; i <= this.currentLevel; ++i) {
                this.write(output, "  ");
            }
        }
    }

    private void write(Writer writer, String s) {
        try {
            writer.write(s);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException", ex);
        }
    }

    @Override
    public void openArray(Writer output, Object[] array, String name, Object parent) {
        this.openLevel(output, "[", name);
    }

    @Override
    public void closeArray(Writer output, Object[] array, String name, Object parent) {
        this.closeLevel(output, "]");
    }

    @Override
    public void openCollection(Writer output, Collection<?> collection, String name, Object parent) {
        this.openLevel(output, "[", name);
    }

    @Override
    public void closeCollection(Writer output, Collection<?> collection, String name, Object parent) {
        this.closeLevel(output, "]");
    }

    private void openLevel(Writer output, String sOpeningCharacter, String sPropertyName) {
        if (this.isNotFirstValueInCurrentLevel()) {
            this.write(output, ", ");
        }
        this.writeNewLine(output);
        if (sPropertyName != null) {
            this.write(output, "\"" + sPropertyName + "\" : ");
        }
        this.write(output, sOpeningCharacter);
        ++this.currentLevel;
        this.levelCount[this.currentLevel] = 0;
    }

    private void closeLevel(Writer output, String s) {
        --this.currentLevel;
        this.writeNewLine(output);
        this.write(output, s);
        this.incrementValueInCurrentLevel();
    }

    private boolean isNotFirstValueInCurrentLevel() {
        return this.levelCount[this.currentLevel] > 0;
    }

    private void incrementValueInCurrentLevel() {
        int n = this.currentLevel;
        this.levelCount[n] = this.levelCount[n] + 1;
    }
}

