/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanwriter.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.nanoj.util.DateUtil;

public final class JsonUtil {
    private static final String NULL = "null";

    private JsonUtil() {
    }

    public static String jsonString(String sStdString) {
        if (sStdString == null) {
            return NULL;
        }
        StringBuffer sb = new StringBuffer(sStdString.length() + 40);
        sb.append('\"');
        block9: for (int i = 0; i < sStdString.length(); ++i) {
            char c = sStdString.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '/': {
                    sb.append("\\/");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String jsonDate(Date date) {
        if (date == null) {
            return NULL;
        }
        return "\"" + DateUtil.dateISO(date) + "\"";
    }

    public static String jsonBool(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public static String jsonBool(Boolean v) {
        return v != null ? v.toString() : NULL;
    }

    public static String jsonNumber(Number v) {
        return v != null ? v.toString() : NULL;
    }

    public static String jsonObjectValue(Object obj) {
        if (null == obj) {
            return NULL;
        }
        if (obj instanceof String) {
            return JsonUtil.jsonString((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).toString();
        }
        if (obj instanceof Boolean) {
            return ((Boolean)obj).toString();
        }
        if (obj instanceof java.sql.Date) {
            return "\"" + ((java.sql.Date)obj).toString() + "\"";
        }
        if (obj instanceof Time) {
            return "\"" + ((Time)obj).toString() + "\"";
        }
        if (obj instanceof Timestamp) {
            return "\"" + ((Timestamp)obj).toString() + "\"";
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            return "\"" + DateUtil.dateTimeISO(date) + "\"";
        }
        if (obj instanceof Character) {
            Character c = (Character)obj;
            return "\"" + c.toString() + "\"";
        }
        if (obj instanceof StringBuffer) {
            return JsonUtil.jsonString(((StringBuffer)obj).toString());
        }
        throw new RuntimeException("Cannot convert '" + obj.getClass().getName() + "' to JSON value");
    }
}

