/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.beanwriter.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.nanoj.util.DateUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static String xmlString(String sStdString) {
        if (sStdString == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(sStdString.length() + 40);
        block7: for (int i = 0; i < sStdString.length(); ++i) {
            char c = sStdString.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c >= '\u0080') {
                        sb.append("&#" + c + ";");
                        continue block7;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String xmlDate(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtil.dateISO(date);
    }

    public static String xmlBool(boolean b) {
        if (b) {
            return "1";
        }
        return "0";
    }

    private static DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            throw new Exception("XmlUtil.parse() : Cannot create DocumentBuilderFactory ", e);
        }
        catch (Throwable t) {
            throw new Exception("XmlUtil.parse() : Cannot create DocumentBuilderFactory ", t);
        }
        if (factory != null) {
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Exception("XmlUtil.parse() : Cannot create DocumentBuilder ", e);
            }
            catch (Throwable t) {
                throw new Exception("XmlUtil.parse() : Cannot create DocumentBuilder ", t);
            }
        } else {
            throw new Exception("XmlUtil.parse() : DocumentBuilderFactory instance is null");
        }
        if (builder == null) {
            throw new Exception("XmlUtil.parse() : DocumentBuilder instance is null");
        }
        return builder;
    }

    public static Document parse(String sFileName) throws Exception {
        File file = new File(sFileName);
        if (!file.exists()) {
            throw new Exception("XmlUtil.parse() : file '" + sFileName + "' not found ! ");
        }
        return XmlUtil.parse(file);
    }

    public static Document parse(File file) throws Exception {
        Document document = null;
        DocumentBuilder builder = XmlUtil.getDocumentBuilder();
        if (builder != null) {
            try {
                document = builder.parse(file);
            }
            catch (SAXException e) {
                throw new Exception("XmlUtil.parse() : SAXException ", e);
            }
            catch (IOException e) {
                throw new Exception("XmlUtil.parse() : IOException ", e);
            }
            catch (Throwable t) {
                throw new Exception("XmlUtil.parse() : Throwable ", t);
            }
        }
        return document;
    }

    public static Document parse(InputStream is) throws Exception {
        Document document = null;
        DocumentBuilder builder = XmlUtil.getDocumentBuilder();
        if (builder != null) {
            try {
                document = builder.parse(is);
            }
            catch (SAXException e) {
                throw new Exception("XmlUtil.parse() : SAXException ", e);
            }
            catch (IOException e) {
                throw new Exception("XmlUtil.parse() : IOException ", e);
            }
            catch (Throwable t) {
                throw new Exception("XmlUtil.parse() : Throwable ", t);
            }
        }
        return document;
    }
}

