/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.file;

import org.nanoj.util.file.GenericFileParser;

public abstract class CSVFileParser
extends GenericFileParser {
    private static final char NO_SEPARATOR = '\u0000';
    private char _separatorChar = '\u0000';

    public CSVFileParser(char separatorChar) {
        this._separatorChar = separatorChar;
    }

    public CSVFileParser(char separatorChar, String commentString) {
        super(commentString);
        this._separatorChar = separatorChar;
    }

    public CSVFileParser(String separatorChar) {
        this._separatorChar = '\u0000';
        if (separatorChar != null && separatorChar.length() > 0) {
            this._separatorChar = separatorChar.charAt(0);
        }
    }

    public CSVFileParser(String separatorChar, String commentString) {
        super(commentString);
        this._separatorChar = '\u0000';
        if (separatorChar != null && separatorChar.length() > 0) {
            this._separatorChar = separatorChar.charAt(0);
        }
    }

    public char getSeparatorChar() {
        return this._separatorChar;
    }

    protected abstract void dataLine(int var1, String var2, String[] var3);

    @Override
    protected void dataLine(int lineNumber, String line) {
        String[] fields = this.split(line);
        this.dataLine(lineNumber, line, fields);
    }

    private String[] split(String sLine) {
        int len = sLine.length();
        char[] chars = new char[len];
        sLine.getChars(0, len, chars, 0);
        int iFieldCount = this.getFieldCount(chars);
        String[] fields = new String[iFieldCount];
        int iFieldIndex = 0;
        int iOffset = -1;
        int iCount = 0;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == this._separatorChar) {
                fields[iFieldIndex++] = this.getField(chars, iOffset, iCount);
                iOffset = -1;
                iCount = 0;
                continue;
            }
            if (iOffset == -1) {
                iOffset = i;
            }
            ++iCount;
        }
        fields[iFieldIndex++] = this.getField(chars, iOffset, iCount);
        return fields;
    }

    private int getFieldCount(char[] chars) {
        int len = chars.length;
        int iCount = 0;
        for (int i = 0; i < len; ++i) {
            if (chars[i] != this._separatorChar) continue;
            ++iCount;
        }
        return iCount + 1;
    }

    private String getField(char[] chars, int iOffset, int iCount) {
        if (iOffset < 0) {
            return "";
        }
        return new String(chars, iOffset, iCount);
    }
}

