/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.file;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public abstract class GenericFileParser {
    private static final int BUFFER_SIZE = 2048;
    private String _commentString = null;

    protected abstract void start();

    protected abstract void commentLine(int var1, String var2);

    protected abstract void voidLine(int var1);

    protected abstract void dataLine(int var1, String var2);

    protected abstract void end();

    public abstract List<Object> getResult();

    protected GenericFileParser() {
        this._commentString = null;
    }

    protected GenericFileParser(String commentString) {
        this._commentString = commentString;
    }

    protected String getCommentString() {
        return this._commentString;
    }

    public void parse(String sFileName) throws FileNotFoundException, IOException {
        FileReader fr = new FileReader(sFileName);
        BufferedReader br = new BufferedReader(fr, 2048);
        try {
            this.parse(br);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            br.close();
            fr.close();
        }
    }

    public void parse(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr, 2048);
        try {
            this.parse(br);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            br.close();
            isr.close();
        }
    }

    public void parse(BufferedReader br) throws IOException {
        String sLine;
        int iRowNum = 0;
        this.start();
        while ((sLine = br.readLine()) != null) {
            ++iRowNum;
            if (sLine.length() == 0) {
                this.voidLine(iRowNum);
                continue;
            }
            if (this.isComment(sLine)) {
                this.commentLine(iRowNum, sLine);
                continue;
            }
            this.dataLine(iRowNum, sLine);
        }
        this.end();
        br.close();
    }

    private boolean isComment(String sLine) {
        return this._commentString != null && sLine.startsWith(this._commentString);
    }
}

