/*
 * Decompiled with CFR 0.152.
 */
package org.nanoj.util.http;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.nanoj.util.http.HttpClientResponse;

public class HttpClient {
    private Boolean followRedirects = null;

    public HttpClientResponse get(String url) throws Exception {
        return this.get(this.getURL(url));
    }

    public HttpClientResponse get(URL url) throws Exception {
        return this.process(url, "GET", null);
    }

    public HttpClientResponse head(String url) throws Exception {
        return this.head(this.getURL(url));
    }

    public HttpClientResponse head(URL url) throws Exception {
        return this.process(url, "HEAD", null);
    }

    public HttpClientResponse post(String url, String data) throws Exception {
        byte[] dataBytes = null;
        if (data != null) {
            dataBytes = data.getBytes();
        }
        return this.post(url, dataBytes);
    }

    public HttpClientResponse post(String url, byte[] data) throws Exception {
        return this.post(this.getURL(url), data);
    }

    public HttpClientResponse post(URL url, byte[] data) throws Exception {
        return this.process(url, "POST", data);
    }

    public HttpClientResponse put(String url, String data) throws Exception {
        byte[] dataBytes = null;
        if (data != null) {
            dataBytes = data.getBytes();
        }
        return this.put(url, dataBytes);
    }

    public HttpClientResponse put(String url, byte[] data) throws Exception {
        return this.put(this.getURL(url), data);
    }

    public HttpClientResponse put(URL url, byte[] data) throws Exception {
        return this.process(url, "PUT", data);
    }

    public HttpClientResponse delete(String url) throws Exception {
        return this.delete(this.getURL(url));
    }

    public HttpClientResponse delete(URL url) throws Exception {
        return this.process(url, "DELETE", null);
    }

    private HttpClientResponse process(URL url, String method, byte[] data) throws Exception {
        HttpURLConnection connection = this.connect(url, method);
        if (data != null) {
            this.writeRequestBody(connection, data);
        }
        HttpClientResponse response = new HttpClientResponse(connection);
        connection.disconnect();
        return response;
    }

    private URL getURL(String sUrl) throws Exception {
        URL url = null;
        try {
            url = new URL(sUrl);
        }
        catch (Exception e) {
            throw new Exception("Invalid URL");
        }
        return url;
    }

    public static void configFollowRedirects(boolean b) {
        HttpURLConnection.setFollowRedirects(b);
    }

    public static boolean getConfigFollowRedirects() {
        return HttpURLConnection.getFollowRedirects();
    }

    public static void configProxy(String proxyHost, String proxyPort) {
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", proxyPort);
    }

    public static void configTrustStore(String trustStoreFile, String trustStorePassword) {
        System.setProperty("javax.net.ssl.trustStore", trustStoreFile);
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
    }

    public void setFollowRedirects(boolean b) {
        this.followRedirects = b;
    }

    public boolean getFollowRedirects() {
        if (this.followRedirects != null) {
            return this.followRedirects;
        }
        return HttpClient.getConfigFollowRedirects();
    }

    private HttpURLConnection connect(URL url, String method) throws Exception {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            if (this.followRedirects != null) {
                connection.setInstanceFollowRedirects(this.followRedirects);
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod(method);
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            connection.connect();
            return connection;
        }
        catch (Exception e) {
            throw new Exception("Connection failed");
        }
    }

    private void writeRequestBody(HttpURLConnection connection, byte[] data) throws Exception {
        try {
            OutputStream os = connection.getOutputStream();
            os.write(data);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            throw new Exception("Cannot write data in the request body (unable to write in output stream)");
        }
    }
}

